/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay;

import com.huifu.adapay.core.AdapayCore;
import com.huifu.adapay.core.notify.INotifyCallback;
import com.huifu.adapay.core.notify.MqttCallbackEvent;
import com.huifu.adapay.model.MerConfig;
import com.huifu.adapay.notify.MQTTCallbackHandler;
import com.huifu.adapay.notify.MQTTMsgRec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Adapay {
    public static volatile String sdk_version = "Java_v1.1.1";
    public static volatile String publicKey = null;
    public static volatile String deviceID = "Adapay_0001";
    public static volatile MQTTCallbackHandler mqttCallback = null;
    public static volatile boolean debug = false;
    public static volatile boolean prodMode = true;
    public static volatile boolean verifyRSA = true;
    public static volatile String apiBase = "https://api.adapay.tech";
    public static volatile String pageBase = "https://page.adapay.tech";
    public static final String defaultMerchantKey = "default";
    private static volatile Map<String, MerConfig> configMap = new HashMap<String, MerConfig>();
    private static Set<String> mqttSet = new HashSet<String>();

    private Adapay() {
    }

    public static void addMerConfig(MerConfig merConfig, String merchantKey) throws Exception {
        MqttCallbackEvent.getMqttToken((String)merConfig.getRSAPrivateKey(), (String)merConfig.getApiKey());
        configMap.put(merchantKey, merConfig);
    }

    public static void initWithMerConfig(MerConfig merConfig, MQTTCallbackHandler handler) throws Exception {
        Adapay.configEnv();
        if (merConfig == null) {
            throw new Exception("\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (handler == null) {
            throw new Exception("\u5f02\u6b65\u5904\u7406\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MqttCallbackEvent.getMqttToken((String)merConfig.getRSAPrivateKey(), (String)merConfig.getApiKey());
        configMap.put(defaultMerchantKey, merConfig);
        Adapay.startMqttListener(merConfig, handler);
    }

    public static void initWithMerConfig(MerConfig merConfig) throws Exception {
        Adapay.configEnv();
        if (merConfig == null) {
            throw new Exception("\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MqttCallbackEvent.getMqttToken((String)merConfig.getRSAPrivateKey(), (String)merConfig.getApiKey());
        configMap.put(defaultMerchantKey, merConfig);
    }

    public static synchronized void startMqttListener(MerConfig merConfig, MQTTCallbackHandler handler) throws Exception {
        String apikey = merConfig.getApiKey();
        MQTTMsgRec msgRec = new MQTTMsgRec(handler);
        if (!prodMode) {
            apikey = merConfig.getApiMockKey();
        }
        if (mqttSet.contains(apikey)) {
            System.out.println("\u91cd\u590d\u7533\u8bf7MQTT" + apikey);
            return;
        }
        MqttCallbackEvent.startMqtt((String)apikey, (String)merConfig.getRSAPrivateKey(), (INotifyCallback)msgRec, (String)deviceID);
        mqttSet.add(apikey);
    }

    private static void configEnv() {
        AdapayCore.debug = debug;
        AdapayCore.apiBase = apiBase;
        AdapayCore.pageBase = pageBase;
        AdapayCore.sdkVersion = sdk_version;
        if (publicKey != null) {
            AdapayCore.PUBLIC_KEY = publicKey;
        }
    }

    public static void initWithMerConfigs(Map<String, MerConfig> multiConfigs) throws Exception {
        Adapay.configEnv();
        if (multiConfigs == null) {
            throw new Exception("\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (multiConfigs.size() > 0) {
            for (Map.Entry<String, MerConfig> entry : multiConfigs.entrySet()) {
                try {
                    if (verifyRSA) {
                        MqttCallbackEvent.getMqttToken((String)entry.getValue().getRSAPrivateKey(), (String)entry.getValue().getApiKey());
                    }
                    configMap.put(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    System.out.println("\u521d\u59cb\u5316\u6821\u9a8c\u914d\u7f6e\u51fa\u73b0\u9519\u8bef\uff0c\u5e38\u89c1\u662f\u79d8\u94a5\u4e0d\u5339\u914d," + entry.getValue().getApiKey());
                }
            }
        } else {
            throw new Exception("\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static MerConfig getConfig(String merchantKey) {
        return configMap.get(merchantKey);
    }

    public static String getDeviceID() {
        return deviceID;
    }

    public static void setDeviceID(String deviceID) {
        Adapay.deviceID = deviceID;
    }
}

