/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.polynomial;

import com.timevale.tgtext.bouncycastle.math.ntru.euclid.BigIntEuclidean;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.BigIntPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Constants;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.LongPolynomial2;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.ModularResultant;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Polynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Resultant;
import com.timevale.tgtext.bouncycastle.math.ntru.util.ArrayEncoder;
import com.timevale.tgtext.bouncycastle.math.ntru.util.Util;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class IntegerPolynomial
implements Polynomial {
    private static final int NUM_EQUAL_RESULTANTS = 3;
    private static final int[] PRIMES = new int[]{4507, 4513, 4517, 4519, 4523, 4547, 4549, 4561, 4567, 4583, 4591, 4597, 4603, 4621, 4637, 4639, 4643, 4649, 4651, 4657, 4663, 4673, 4679, 4691, 4703, 4721, 4723, 4729, 4733, 4751, 4759, 4783, 4787, 4789, 4793, 4799, 4801, 4813, 4817, 4831, 4861, 4871, 4877, 4889, 4903, 4909, 4919, 4931, 4933, 4937, 4943, 4951, 4957, 4967, 4969, 4973, 4987, 4993, 4999, 5003, 5009, 5011, 5021, 5023, 5039, 5051, 5059, 5077, 5081, 5087, 5099, 5101, 5107, 5113, 5119, 5147, 5153, 5167, 5171, 5179, 5189, 5197, 5209, 5227, 5231, 5233, 5237, 5261, 5273, 5279, 5281, 5297, 5303, 5309, 5323, 5333, 5347, 5351, 5381, 5387, 5393, 5399, 5407, 5413, 5417, 5419, 5431, 5437, 5441, 5443, 5449, 5471, 5477, 5479, 5483, 5501, 5503, 5507, 5519, 5521, 5527, 5531, 5557, 5563, 5569, 5573, 5581, 5591, 5623, 5639, 5641, 5647, 5651, 5653, 5657, 5659, 5669, 5683, 5689, 5693, 5701, 5711, 5717, 5737, 5741, 5743, 5749, 5779, 5783, 5791, 5801, 5807, 5813, 5821, 5827, 5839, 5843, 5849, 5851, 5857, 5861, 5867, 5869, 5879, 5881, 5897, 5903, 5923, 5927, 5939, 5953, 5981, 5987, 6007, 6011, 6029, 6037, 6043, 6047, 6053, 6067, 6073, 6079, 6089, 6091, 6101, 6113, 6121, 6131, 6133, 6143, 6151, 6163, 6173, 6197, 6199, 6203, 6211, 6217, 6221, 6229, 6247, 6257, 6263, 6269, 6271, 6277, 6287, 6299, 6301, 6311, 6317, 6323, 6329, 6337, 6343, 6353, 6359, 6361, 6367, 6373, 6379, 6389, 6397, 6421, 6427, 6449, 6451, 6469, 6473, 6481, 6491, 6521, 6529, 6547, 6551, 6553, 6563, 6569, 6571, 6577, 6581, 6599, 6607, 6619, 6637, 6653, 6659, 6661, 6673, 6679, 6689, 6691, 6701, 6703, 6709, 6719, 6733, 6737, 6761, 6763, 6779, 6781, 6791, 6793, 6803, 6823, 6827, 6829, 6833, 6841, 6857, 6863, 6869, 6871, 6883, 6899, 6907, 6911, 6917, 6947, 6949, 6959, 6961, 6967, 6971, 6977, 6983, 6991, 6997, 7001, 7013, 7019, 7027, 7039, 7043, 7057, 7069, 7079, 7103, 7109, 7121, 7127, 7129, 7151, 7159, 7177, 7187, 7193, 7207, 7211, 7213, 7219, 7229, 7237, 7243, 7247, 7253, 7283, 7297, 7307, 7309, 7321, 7331, 7333, 7349, 7351, 7369, 7393, 7411, 7417, 7433, 7451, 7457, 7459, 7477, 7481, 7487, 7489, 7499, 7507, 7517, 7523, 7529, 7537, 7541, 7547, 7549, 7559, 7561, 7573, 7577, 7583, 7589, 7591, 7603, 7607, 7621, 7639, 7643, 7649, 7669, 7673, 7681, 7687, 7691, 7699, 7703, 7717, 7723, 7727, 7741, 7753, 7757, 7759, 7789, 7793, 7817, 7823, 7829, 7841, 7853, 7867, 7873, 7877, 7879, 7883, 7901, 7907, 7919, 7927, 7933, 7937, 7949, 7951, 7963, 7993, 8009, 8011, 8017, 8039, 8053, 8059, 8069, 8081, 8087, 8089, 8093, 8101, 8111, 8117, 8123, 8147, 8161, 8167, 8171, 8179, 8191, 8209, 8219, 8221, 8231, 8233, 8237, 8243, 8263, 8269, 8273, 8287, 8291, 8293, 8297, 8311, 8317, 8329, 8353, 8363, 8369, 8377, 8387, 8389, 8419, 8423, 8429, 8431, 8443, 8447, 8461, 8467, 8501, 8513, 8521, 8527, 8537, 8539, 8543, 8563, 8573, 8581, 8597, 8599, 8609, 8623, 8627, 8629, 8641, 8647, 8663, 8669, 8677, 8681, 8689, 8693, 8699, 8707, 8713, 8719, 8731, 8737, 8741, 8747, 8753, 8761, 8779, 8783, 8803, 8807, 8819, 8821, 8831, 8837, 8839, 8849, 8861, 8863, 8867, 8887, 8893, 8923, 8929, 8933, 8941, 8951, 8963, 8969, 8971, 8999, 9001, 9007, 9011, 9013, 9029, 9041, 9043, 9049, 9059, 9067, 9091, 9103, 9109, 9127, 9133, 9137, 9151, 9157, 9161, 9173, 9181, 9187, 9199, 9203, 9209, 9221, 9227, 9239, 9241, 9257, 9277, 9281, 9283, 9293, 9311, 9319, 9323, 9337, 9341, 9343, 9349, 9371, 9377, 9391, 9397, 9403, 9413, 9419, 9421, 9431, 9433, 9437, 9439, 9461, 9463, 9467, 9473, 9479, 9491, 9497, 9511, 9521, 9533, 9539, 9547, 9551, 9587, 9601, 9613, 9619, 9623, 9629, 9631, 9643, 9649, 9661, 9677, 9679, 9689, 9697, 9719, 9721, 9733, 9739, 9743, 9749, 9767, 9769, 9781, 9787, 9791, 9803, 9811, 9817, 9829, 9833, 9839, 9851, 9857, 9859, 9871, 9883, 9887, 9901, 9907, 9923, 9929, 9931, 9941, 9949, 9967, 9973};
    private static final List BIGINT_PRIMES = new ArrayList();
    public int[] coeffs;

    public IntegerPolynomial(int N) {
        this.coeffs = new int[N];
    }

    public IntegerPolynomial(int[] coeffs) {
        this.coeffs = coeffs;
    }

    public IntegerPolynomial(BigIntPolynomial p2) {
        this.coeffs = new int[p2.coeffs.length];
        for (int i2 = 0; i2 < p2.coeffs.length; ++i2) {
            this.coeffs[i2] = p2.coeffs[i2].intValue();
        }
    }

    public static IntegerPolynomial fromBinary3Sves(byte[] data, int N) {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Sves(data, N));
    }

    public static IntegerPolynomial fromBinary3Tight(byte[] b2, int N) {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Tight(b2, N));
    }

    public static IntegerPolynomial fromBinary3Tight(InputStream is, int N) throws IOException {
        return new IntegerPolynomial(ArrayEncoder.decodeMod3Tight(is, N));
    }

    public static IntegerPolynomial fromBinary(byte[] data, int N, int q2) {
        return new IntegerPolynomial(ArrayEncoder.decodeModQ(data, N, q2));
    }

    public static IntegerPolynomial fromBinary(InputStream is, int N, int q2) throws IOException {
        return new IntegerPolynomial(ArrayEncoder.decodeModQ(is, N, q2));
    }

    public byte[] toBinary3Sves() {
        return ArrayEncoder.encodeMod3Sves(this.coeffs);
    }

    public byte[] toBinary3Tight() {
        BigInteger sum = Constants.BIGINT_ZERO;
        for (int i2 = this.coeffs.length - 1; i2 >= 0; --i2) {
            sum = sum.multiply(BigInteger.valueOf(3L));
            sum = sum.add(BigInteger.valueOf(this.coeffs[i2] + 1));
        }
        int size = (BigInteger.valueOf(3L).pow(this.coeffs.length).bitLength() + 7) / 8;
        byte[] arr = sum.toByteArray();
        if (arr.length < size) {
            byte[] arr2 = new byte[size];
            System.arraycopy(arr, 0, arr2, size - arr.length, arr.length);
            return arr2;
        }
        if (arr.length > size) {
            arr = Arrays.copyOfRange(arr, 1, arr.length);
        }
        return arr;
    }

    public byte[] toBinary(int q2) {
        return ArrayEncoder.encodeModQ(this.coeffs, q2);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2, int modulus) {
        IntegerPolynomial c2 = this.mult(poly2);
        c2.mod(modulus);
        return c2;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2) {
        int N = this.coeffs.length;
        if (poly2.coeffs.length != N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        IntegerPolynomial c2 = this.multRecursive(poly2);
        if (c2.coeffs.length > N) {
            for (int k2 = N; k2 < c2.coeffs.length; ++k2) {
                int n2 = k2 - N;
                c2.coeffs[n2] = c2.coeffs[n2] + c2.coeffs[k2];
            }
            c2.coeffs = Arrays.copyOf(c2.coeffs, N);
        }
        return c2;
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial poly2) {
        return new BigIntPolynomial(this).mult(poly2);
    }

    private IntegerPolynomial multRecursive(IntegerPolynomial poly2) {
        int i2;
        int[] a2 = this.coeffs;
        int[] b2 = poly2.coeffs;
        int n2 = poly2.coeffs.length;
        if (n2 <= 32) {
            int cn2 = 2 * n2 - 1;
            IntegerPolynomial c2 = new IntegerPolynomial(new int[cn2]);
            for (int k2 = 0; k2 < cn2; ++k2) {
                for (int i3 = Math.max(0, k2 - n2 + 1); i3 <= Math.min(k2, n2 - 1); ++i3) {
                    int n3 = k2;
                    c2.coeffs[n3] = c2.coeffs[n3] + b2[i3] * a2[k2 - i3];
                }
            }
            return c2;
        }
        int n1 = n2 / 2;
        IntegerPolynomial a1 = new IntegerPolynomial(Arrays.copyOf(a2, n1));
        IntegerPolynomial a22 = new IntegerPolynomial(Arrays.copyOfRange(a2, n1, n2));
        IntegerPolynomial b1 = new IntegerPolynomial(Arrays.copyOf(b2, n1));
        IntegerPolynomial b22 = new IntegerPolynomial(Arrays.copyOfRange(b2, n1, n2));
        IntegerPolynomial A = (IntegerPolynomial)a1.clone();
        A.add(a22);
        IntegerPolynomial B = (IntegerPolynomial)b1.clone();
        B.add(b22);
        IntegerPolynomial c1 = a1.multRecursive(b1);
        IntegerPolynomial c2 = a22.multRecursive(b22);
        IntegerPolynomial c3 = A.multRecursive(B);
        c3.sub(c1);
        c3.sub(c2);
        IntegerPolynomial c4 = new IntegerPolynomial(2 * n2 - 1);
        for (i2 = 0; i2 < c1.coeffs.length; ++i2) {
            c4.coeffs[i2] = c1.coeffs[i2];
        }
        for (i2 = 0; i2 < c3.coeffs.length; ++i2) {
            int n4 = n1 + i2;
            c4.coeffs[n4] = c4.coeffs[n4] + c3.coeffs[i2];
        }
        for (i2 = 0; i2 < c2.coeffs.length; ++i2) {
            int n5 = 2 * n1 + i2;
            c4.coeffs[n5] = c4.coeffs[n5] + c2.coeffs[i2];
        }
        return c4;
    }

    public IntegerPolynomial invertFq(int q2) {
        int N = this.coeffs.length;
        int k2 = 0;
        IntegerPolynomial b2 = new IntegerPolynomial(N + 1);
        b2.coeffs[0] = 1;
        IntegerPolynomial c2 = new IntegerPolynomial(N + 1);
        IntegerPolynomial f2 = new IntegerPolynomial(N + 1);
        new IntegerPolynomial(N + 1).coeffs = Arrays.copyOf(this.coeffs, N + 1);
        f2.modPositive(2);
        IntegerPolynomial g2 = new IntegerPolynomial(N + 1);
        g2.coeffs[0] = 1;
        g2.coeffs[N] = 1;
        while (true) {
            if (f2.coeffs[0] == 0) {
                for (int i2 = 1; i2 <= N; ++i2) {
                    f2.coeffs[i2 - 1] = f2.coeffs[i2];
                    c2.coeffs[N + 1 - i2] = c2.coeffs[N - i2];
                }
                f2.coeffs[N] = 0;
                c2.coeffs[0] = 0;
                ++k2;
                if (!f2.equalsZero()) continue;
                return null;
            }
            if (f2.equalsOne()) break;
            if (f2.degree() < g2.degree()) {
                IntegerPolynomial temp = f2;
                f2 = g2;
                g2 = temp;
                temp = b2;
                b2 = c2;
                c2 = temp;
            }
            f2.add(g2, 2);
            b2.add(c2, 2);
        }
        if (b2.coeffs[N] != 0) {
            return null;
        }
        IntegerPolynomial Fq = new IntegerPolynomial(N);
        k2 %= N;
        for (int i3 = N - 1; i3 >= 0; --i3) {
            int j2 = i3 - k2;
            if (j2 < 0) {
                j2 += N;
            }
            Fq.coeffs[j2] = b2.coeffs[i3];
        }
        return this.mod2ToModq(Fq, q2);
    }

    private IntegerPolynomial mod2ToModq(IntegerPolynomial Fq, int q2) {
        if (Util.is64BitJVM() && q2 == 2048) {
            LongPolynomial2 thisLong = new LongPolynomial2(this);
            LongPolynomial2 FqLong = new LongPolynomial2(Fq);
            int v2 = 2;
            while (v2 < q2) {
                LongPolynomial2 temp = (LongPolynomial2)FqLong.clone();
                temp.mult2And((v2 <<= 1) - 1);
                FqLong = thisLong.mult(FqLong).mult(FqLong);
                temp.subAnd(FqLong, v2 - 1);
                FqLong = temp;
            }
            return FqLong.toIntegerPolynomial();
        }
        int v3 = 2;
        while (v3 < q2) {
            IntegerPolynomial temp = new IntegerPolynomial(Arrays.copyOf(Fq.coeffs, Fq.coeffs.length));
            temp.mult2(v3 <<= 1);
            Fq = this.mult(Fq, v3).mult(Fq, v3);
            temp.sub(Fq, v3);
            Fq = temp;
        }
        return Fq;
    }

    public IntegerPolynomial invertF3() {
        int N = this.coeffs.length;
        int k2 = 0;
        IntegerPolynomial b2 = new IntegerPolynomial(N + 1);
        b2.coeffs[0] = 1;
        IntegerPolynomial c2 = new IntegerPolynomial(N + 1);
        IntegerPolynomial f2 = new IntegerPolynomial(N + 1);
        new IntegerPolynomial(N + 1).coeffs = Arrays.copyOf(this.coeffs, N + 1);
        f2.modPositive(3);
        IntegerPolynomial g2 = new IntegerPolynomial(N + 1);
        g2.coeffs[0] = -1;
        g2.coeffs[N] = 1;
        while (true) {
            if (f2.coeffs[0] == 0) {
                for (int i2 = 1; i2 <= N; ++i2) {
                    f2.coeffs[i2 - 1] = f2.coeffs[i2];
                    c2.coeffs[N + 1 - i2] = c2.coeffs[N - i2];
                }
                f2.coeffs[N] = 0;
                c2.coeffs[0] = 0;
                ++k2;
                if (!f2.equalsZero()) continue;
                return null;
            }
            if (f2.equalsAbsOne()) break;
            if (f2.degree() < g2.degree()) {
                IntegerPolynomial temp = f2;
                f2 = g2;
                g2 = temp;
                temp = b2;
                b2 = c2;
                c2 = temp;
            }
            if (f2.coeffs[0] == g2.coeffs[0]) {
                f2.sub(g2, 3);
                b2.sub(c2, 3);
                continue;
            }
            f2.add(g2, 3);
            b2.add(c2, 3);
        }
        if (b2.coeffs[N] != 0) {
            return null;
        }
        IntegerPolynomial Fp2 = new IntegerPolynomial(N);
        k2 %= N;
        for (int i3 = N - 1; i3 >= 0; --i3) {
            int j2 = i3 - k2;
            if (j2 < 0) {
                j2 += N;
            }
            Fp2.coeffs[j2] = f2.coeffs[0] * b2.coeffs[i3];
        }
        Fp2.ensurePositive(3);
        return Fp2;
    }

    public Resultant resultant() {
        int N = this.coeffs.length;
        LinkedList<ModularResultant> modResultants = new LinkedList<ModularResultant>();
        BigInteger prime = null;
        BigInteger pProd = Constants.BIGINT_ONE;
        BigInteger res = Constants.BIGINT_ONE;
        int numEqual = 1;
        Iterator primes = BIGINT_PRIMES.iterator();
        while (true) {
            prime = primes.hasNext() ? (BigInteger)primes.next() : prime.nextProbablePrime();
            ModularResultant crr = this.resultant(prime.intValue());
            modResultants.add(crr);
            BigInteger temp = pProd.multiply(prime);
            BigIntEuclidean er2 = BigIntEuclidean.calculate(prime, pProd);
            BigInteger resPrev = res;
            res = res.multiply(er2.x.multiply(prime));
            BigInteger res2 = crr.res.multiply(er2.y.multiply(pProd));
            res = res.add(res2).mod(temp);
            pProd = temp;
            BigInteger pProd2 = pProd.divide(BigInteger.valueOf(2L));
            BigInteger pProd2n = pProd2.negate();
            if (res.compareTo(pProd2) > 0) {
                res = res.subtract(pProd);
            } else if (res.compareTo(pProd2n) < 0) {
                res = res.add(pProd);
            }
            if (res.equals(resPrev)) {
                if (++numEqual < 3) continue;
                break;
            }
            numEqual = 1;
        }
        while (modResultants.size() > 1) {
            ModularResultant modRes1 = (ModularResultant)modResultants.removeFirst();
            ModularResultant modRes2 = (ModularResultant)modResultants.removeFirst();
            ModularResultant modRes3 = ModularResultant.combineRho(modRes1, modRes2);
            modResultants.addLast(modRes3);
        }
        BigIntPolynomial rhoP = ((ModularResultant)modResultants.getFirst()).rho;
        BigInteger pProd2 = pProd.divide(BigInteger.valueOf(2L));
        BigInteger pProd2n = pProd2.negate();
        if (res.compareTo(pProd2) > 0) {
            res = res.subtract(pProd);
        }
        if (res.compareTo(pProd2n) < 0) {
            res = res.add(pProd);
        }
        for (int i2 = 0; i2 < N; ++i2) {
            BigInteger c2 = rhoP.coeffs[i2];
            if (c2.compareTo(pProd2) > 0) {
                rhoP.coeffs[i2] = c2.subtract(pProd);
            }
            if (c2.compareTo(pProd2n) >= 0) continue;
            rhoP.coeffs[i2] = c2.add(pProd);
        }
        return new Resultant(rhoP, res);
    }

    public Resultant resultantMultiThread() {
        int N = this.coeffs.length;
        BigInteger max = this.squareSum().pow((N + 1) / 2);
        max = max.multiply(BigInteger.valueOf(2L).pow((this.degree() + 1) / 2));
        BigInteger max2 = max.multiply(BigInteger.valueOf(2L));
        BigInteger prime = BigInteger.valueOf(10000L);
        BigInteger pProd = Constants.BIGINT_ONE;
        LinkedBlockingQueue<Future<ModularResultant>> resultantTasks = new LinkedBlockingQueue<Future<ModularResultant>>();
        Iterator primes = BIGINT_PRIMES.iterator();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        while (pProd.compareTo(max2) < 0) {
            prime = primes.hasNext() ? (BigInteger)primes.next() : prime.nextProbablePrime();
            Future<ModularResultant> task = executor.submit(new b(prime.intValue()));
            resultantTasks.add(task);
            pProd = pProd.multiply(prime);
        }
        ModularResultant overallResultant = null;
        while (!resultantTasks.isEmpty()) {
            try {
                Future modRes1 = (Future)resultantTasks.take();
                Future modRes2 = (Future)resultantTasks.poll();
                if (modRes2 == null) {
                    overallResultant = (ModularResultant)modRes1.get();
                    break;
                }
                Future<ModularResultant> newTask = executor.submit(new a((ModularResultant)modRes1.get(), (ModularResultant)modRes2.get()));
                resultantTasks.add(newTask);
            }
            catch (Exception e2) {
                throw new IllegalStateException(e2.toString());
            }
        }
        executor.shutdown();
        BigInteger res = overallResultant.res;
        BigIntPolynomial rhoP = overallResultant.rho;
        BigInteger pProd2 = pProd.divide(BigInteger.valueOf(2L));
        BigInteger pProd2n = pProd2.negate();
        if (res.compareTo(pProd2) > 0) {
            res = res.subtract(pProd);
        }
        if (res.compareTo(pProd2n) < 0) {
            res = res.add(pProd);
        }
        for (int i2 = 0; i2 < N; ++i2) {
            BigInteger c2 = rhoP.coeffs[i2];
            if (c2.compareTo(pProd2) > 0) {
                rhoP.coeffs[i2] = c2.subtract(pProd);
            }
            if (c2.compareTo(pProd2n) >= 0) continue;
            rhoP.coeffs[i2] = c2.add(pProd);
        }
        return new Resultant(rhoP, res);
    }

    public ModularResultant resultant(int p2) {
        int c2;
        int[] fcoeffs = Arrays.copyOf(this.coeffs, this.coeffs.length + 1);
        IntegerPolynomial f2 = new IntegerPolynomial(fcoeffs);
        int N = fcoeffs.length;
        IntegerPolynomial a2 = new IntegerPolynomial(N);
        a2.coeffs[0] = -1;
        a2.coeffs[N - 1] = 1;
        IntegerPolynomial b2 = new IntegerPolynomial(f2.coeffs);
        IntegerPolynomial v1 = new IntegerPolynomial(N);
        IntegerPolynomial v2 = new IntegerPolynomial(N);
        v2.coeffs[0] = 1;
        int da2 = N - 1;
        int db2 = b2.degree();
        int ta = da2;
        int r2 = 1;
        while (db2 > 0) {
            c2 = Util.invert(b2.coeffs[db2], p2);
            c2 = c2 * a2.coeffs[da2] % p2;
            a2.multShiftSub(b2, c2, da2 - db2, p2);
            v1.multShiftSub(v2, c2, da2 - db2, p2);
            da2 = a2.degree();
            if (da2 >= db2) continue;
            r2 *= Util.pow(b2.coeffs[db2], ta - da2, p2);
            r2 %= p2;
            if (ta % 2 == 1 && db2 % 2 == 1) {
                r2 = -r2 % p2;
            }
            IntegerPolynomial temp = a2;
            a2 = b2;
            b2 = temp;
            int tempdeg = da2;
            da2 = db2;
            temp = v1;
            v1 = v2;
            v2 = temp;
            ta = db2;
            db2 = tempdeg;
        }
        r2 *= Util.pow(b2.coeffs[0], da2, p2);
        c2 = Util.invert(b2.coeffs[0], p2);
        v2.mult(c2);
        v2.mod(p2);
        v2.mult(r2 %= p2);
        v2.mod(p2);
        v2.coeffs = Arrays.copyOf(v2.coeffs, v2.coeffs.length - 1);
        return new ModularResultant(new BigIntPolynomial(v2), BigInteger.valueOf(r2), BigInteger.valueOf(p2));
    }

    private void multShiftSub(IntegerPolynomial b2, int c2, int k2, int p2) {
        int N = this.coeffs.length;
        for (int i2 = k2; i2 < N; ++i2) {
            this.coeffs[i2] = (this.coeffs[i2] - b2.coeffs[i2 - k2] * c2) % p2;
        }
    }

    private BigInteger squareSum() {
        BigInteger sum = Constants.BIGINT_ZERO;
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            sum = sum.add(BigInteger.valueOf(this.coeffs[i2] * this.coeffs[i2]));
        }
        return sum;
    }

    int degree() {
        int degree;
        for (degree = this.coeffs.length - 1; degree > 0 && this.coeffs[degree] == 0; --degree) {
        }
        return degree;
    }

    public void add(IntegerPolynomial b2, int modulus) {
        this.add(b2);
        this.mod(modulus);
    }

    public void add(IntegerPolynomial b2) {
        if (b2.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(this.coeffs, b2.coeffs.length);
        }
        for (int i2 = 0; i2 < b2.coeffs.length; ++i2) {
            int n2 = i2;
            this.coeffs[n2] = this.coeffs[n2] + b2.coeffs[i2];
        }
    }

    public void sub(IntegerPolynomial b2, int modulus) {
        this.sub(b2);
        this.mod(modulus);
    }

    public void sub(IntegerPolynomial b2) {
        if (b2.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(this.coeffs, b2.coeffs.length);
        }
        for (int i2 = 0; i2 < b2.coeffs.length; ++i2) {
            int n2 = i2;
            this.coeffs[n2] = this.coeffs[n2] - b2.coeffs[i2];
        }
    }

    void sub(int b2) {
        int i2 = 0;
        while (i2 < this.coeffs.length) {
            int n2 = i2++;
            this.coeffs[n2] = this.coeffs[n2] - b2;
        }
    }

    public void mult(int factor) {
        int i2 = 0;
        while (i2 < this.coeffs.length) {
            int n2 = i2++;
            this.coeffs[n2] = this.coeffs[n2] * factor;
        }
    }

    private void mult2(int modulus) {
        int i2 = 0;
        while (i2 < this.coeffs.length) {
            int n2 = i2;
            this.coeffs[n2] = this.coeffs[n2] << 1;
            int n3 = i2++;
            this.coeffs[n3] = this.coeffs[n3] % modulus;
        }
    }

    public void mult3(int modulus) {
        int i2 = 0;
        while (i2 < this.coeffs.length) {
            int n2 = i2;
            this.coeffs[n2] = this.coeffs[n2] * 3;
            int n3 = i2++;
            this.coeffs[n3] = this.coeffs[n3] % modulus;
        }
    }

    public void div(int k2) {
        int k22 = (k2 + 1) / 2;
        int i2 = 0;
        while (i2 < this.coeffs.length) {
            int n2 = i2;
            this.coeffs[n2] = this.coeffs[n2] + (this.coeffs[i2] > 0 ? k22 : -k22);
            int n3 = i2++;
            this.coeffs[n3] = this.coeffs[n3] / k2;
        }
    }

    public void mod3() {
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            int n2 = i2;
            this.coeffs[n2] = this.coeffs[n2] % 3;
            if (this.coeffs[i2] > 1) {
                int n3 = i2;
                this.coeffs[n3] = this.coeffs[n3] - 3;
            }
            if (this.coeffs[i2] >= -1) continue;
            int n4 = i2;
            this.coeffs[n4] = this.coeffs[n4] + 3;
        }
    }

    public void modPositive(int modulus) {
        this.mod(modulus);
        this.ensurePositive(modulus);
    }

    void modCenter(int modulus) {
        this.mod(modulus);
        for (int j2 = 0; j2 < this.coeffs.length; ++j2) {
            while (this.coeffs[j2] < modulus / 2) {
                int n2 = j2;
                this.coeffs[n2] = this.coeffs[n2] + modulus;
            }
            while (this.coeffs[j2] >= modulus / 2) {
                int n3 = j2;
                this.coeffs[n3] = this.coeffs[n3] - modulus;
            }
        }
    }

    public void mod(int modulus) {
        int i2 = 0;
        while (i2 < this.coeffs.length) {
            int n2 = i2++;
            this.coeffs[n2] = this.coeffs[n2] % modulus;
        }
    }

    public void ensurePositive(int modulus) {
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            while (this.coeffs[i2] < 0) {
                int n2 = i2;
                this.coeffs[n2] = this.coeffs[n2] + modulus;
            }
        }
    }

    public long centeredNormSq(int q2) {
        int N = this.coeffs.length;
        IntegerPolynomial p2 = (IntegerPolynomial)this.clone();
        p2.shiftGap(q2);
        long sum = 0L;
        long sqSum = 0L;
        for (int i2 = 0; i2 != p2.coeffs.length; ++i2) {
            int c2 = p2.coeffs[i2];
            sum += (long)c2;
            sqSum += (long)(c2 * c2);
        }
        long centeredNormSq = sqSum - sum * sum / (long)N;
        return centeredNormSq;
    }

    void shiftGap(int q2) {
        this.modCenter(q2);
        int[] sorted = Arrays.clone(this.coeffs);
        this.sort(sorted);
        int maxrange = 0;
        int maxrangeStart = 0;
        for (int i2 = 0; i2 < sorted.length - 1; ++i2) {
            int range = sorted[i2 + 1] - sorted[i2];
            if (range <= maxrange) continue;
            maxrange = range;
            maxrangeStart = sorted[i2];
        }
        int pmax = sorted[sorted.length - 1];
        int pmin = sorted[0];
        int j2 = q2 - pmax + pmin;
        int shift = j2 > maxrange ? (pmax + pmin) / 2 : maxrangeStart + maxrange / 2 + q2 / 2;
        this.sub(shift);
    }

    private void sort(int[] ints) {
        boolean swap = true;
        while (swap) {
            swap = false;
            for (int i2 = 0; i2 != ints.length - 1; ++i2) {
                if (ints[i2] <= ints[i2 + 1]) continue;
                int tmp = ints[i2];
                ints[i2] = ints[i2 + 1];
                ints[i2 + 1] = tmp;
                swap = true;
            }
        }
    }

    public void center0(int q2) {
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            while (this.coeffs[i2] < -q2 / 2) {
                int n2 = i2;
                this.coeffs[n2] = this.coeffs[n2] + q2;
            }
            while (this.coeffs[i2] > q2 / 2) {
                int n3 = i2;
                this.coeffs[n3] = this.coeffs[n3] - q2;
            }
        }
    }

    public int sumCoeffs() {
        int sum = 0;
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            sum += this.coeffs[i2];
        }
        return sum;
    }

    private boolean equalsZero() {
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            if (this.coeffs[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equalsOne() {
        for (int i2 = 1; i2 < this.coeffs.length; ++i2) {
            if (this.coeffs[i2] == 0) continue;
            return false;
        }
        return this.coeffs[0] == 1;
    }

    private boolean equalsAbsOne() {
        for (int i2 = 1; i2 < this.coeffs.length; ++i2) {
            if (this.coeffs[i2] == 0) continue;
            return false;
        }
        return Math.abs(this.coeffs[0]) == 1;
    }

    public int count(int value) {
        int count = 0;
        for (int i2 = 0; i2 != this.coeffs.length; ++i2) {
            if (this.coeffs[i2] != value) continue;
            ++count;
        }
        return count;
    }

    public void rotate1() {
        int clast = this.coeffs[this.coeffs.length - 1];
        for (int i2 = this.coeffs.length - 1; i2 > 0; --i2) {
            this.coeffs[i2] = this.coeffs[i2 - 1];
        }
        this.coeffs[0] = clast;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            this.coeffs[i2] = 0;
        }
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        return (IntegerPolynomial)this.clone();
    }

    public Object clone() {
        return new IntegerPolynomial((int[])this.coeffs.clone());
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerPolynomial) {
            return Arrays.areEqual(this.coeffs, ((IntegerPolynomial)obj).coeffs);
        }
        return false;
    }

    static {
        for (int i2 = 0; i2 != PRIMES.length; ++i2) {
            BIGINT_PRIMES.add(BigInteger.valueOf(PRIMES[i2]));
        }
    }

    private class a
    implements Callable<ModularResultant> {
        private ModularResultant b;
        private ModularResultant c;

        private a(ModularResultant modRes1, ModularResultant modRes2) {
            this.b = modRes1;
            this.c = modRes2;
        }

        public ModularResultant a() {
            return ModularResultant.combineRho(this.b, this.c);
        }

        @Override
        public /* synthetic */ Object call() throws Exception {
            return this.a();
        }
    }

    private class b
    implements Callable<ModularResultant> {
        private int b;

        private b(int modulus) {
            this.b = modulus;
        }

        public ModularResultant a() {
            return IntegerPolynomial.this.resultant(this.b);
        }

        @Override
        public /* synthetic */ Object call() throws Exception {
            return this.a();
        }
    }
}

