/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.notify;

import com.alibaba.fastjson.JSON;
import com.huifu.adapay.Adapay;
import com.huifu.adapay.core.notify.INotifyCallback;
import com.huifu.adapay.notify.MQTTCallbackHandler;
import com.huifu.adapay.notify.MqttCallBackResponse;
import com.huifu.adapay.notify.NotifyTypeEnum;

public class MQTTMsgRec
implements INotifyCallback {
    private MQTTCallbackHandler asyCallback;

    public MQTTMsgRec(MQTTCallbackHandler asyCallback) {
        this.asyCallback = asyCallback;
    }

    public void messageArrived(String message) throws Exception {
        NotifyTypeEnum notifyTypeEnum;
        MqttCallBackResponse response;
        block3: {
            response = null;
            notifyTypeEnum = null;
            try {
                if (Adapay.debug) {
                    System.out.println("MQTT received message :" + message);
                }
                response = (MqttCallBackResponse)JSON.parseObject((String)message, MqttCallBackResponse.class);
                notifyTypeEnum = NotifyTypeEnum.findByCode(response.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!Adapay.debug) break block3;
                System.out.println("MQTT received message error:" + message);
            }
        }
        this.asyHandler(response, notifyTypeEnum);
    }

    private void asyHandler(MqttCallBackResponse response, NotifyTypeEnum notifyTypeEnum) throws Exception {
        if (notifyTypeEnum == null) {
            this.asyCallback.unknowMessageArrived(JSON.toJSONString((Object)response));
            return;
        }
        switch (notifyTypeEnum) {
            case PAYMENT_SUCCEEDED: {
                this.asyCallback.paymentSuccessMessageArrived(response.getData());
                break;
            }
            case PAYMENT_FAILED: {
                this.asyCallback.paymentFailedMessageArrived(response.getData());
                break;
            }
            case PAYMENT_CLOSE_SUCCEEDED: {
                this.asyCallback.paymentCloseSuccessMessageArrived(response.getData());
                break;
            }
            case PAYMENT_CLOSE_FAILED: {
                this.asyCallback.paymentCloseFailedMessageArrived(response.getData());
                break;
            }
            case REFUND_SUCCEEDED: {
                this.asyCallback.refundSuccessMessageArrived(response.getData());
                break;
            }
            case REFUND_FAILED: {
                this.asyCallback.refundFailedMessageArrived(response.getData());
                break;
            }
            case PAYMENT_REVERSE_SUCCEEDED: {
                this.asyCallback.paymentReverseSuccessMessageArrived(response.getData());
                break;
            }
            case PAYMENT_REVERSE_FAILED: {
                this.asyCallback.paymentReverseFailedMessageArrived(response.getData());
                break;
            }
            case ACCOUNT_PAYMENT_SUCCEEDED: {
                this.asyCallback.pagePaymentSuccessedMessageArrived(response.getData());
                break;
            }
            case ACCOUNT_PAYMENT_FAILED: {
                this.asyCallback.pagePaymentFailedMessageArrived(response.getData());
                break;
            }
            case CORP_MEMBER_SUCCEEDED: {
                this.asyCallback.corpMemberSuccessMessageArrived(response.getData());
                break;
            }
            case CORP_MEMBER_FAILED: {
                this.asyCallback.corpMemberFailedMessageArrived(response.getData());
                break;
            }
            case CASH_FAILED: {
                this.asyCallback.drawCashFailedMessageArrived(response.getData());
                break;
            }
            case CASH_SUCCEEDED: {
                this.asyCallback.drawCashSuccessedMessageArrived(response.getData());
                break;
            }
            default: {
                this.asyCallback.unknowMessageArrived(JSON.toJSONString((Object)response));
                if (!Adapay.debug) break;
                System.out.println("undefind type " + response.getType());
            }
        }
    }

    public void connectionLost() throws Exception {
        this.asyCallback.connectionLost("mqtt connection lost");
    }

    public void connectSuccess() throws Exception {
        this.asyCallback.connectSuccess();
    }
}

