/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.crmf;

import com.timevale.tgtext.bouncycastle.asn1.cms.EnvelopedData;
import com.timevale.tgtext.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.crmf.EncKeyWithID;
import com.timevale.tgtext.bouncycastle.asn1.crmf.EncryptedKey;
import com.timevale.tgtext.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.cert.crmf.PKIArchiveControl;
import com.timevale.tgtext.bouncycastle.cms.CMSEnvelopedData;
import com.timevale.tgtext.bouncycastle.cms.CMSEnvelopedDataGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.tgtext.bouncycastle.cms.RecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

