/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.model;

import com.huifu.adapay.Adapay;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.exception.FailureCode;
import com.huifu.adapay.core.net.AbstractRequest;
import com.huifu.adapay.core.util.ServerTypeEnum;
import com.huifu.adapay.model.MerConfig;
import java.io.File;
import java.util.Map;

public class AdapayRequest
extends AbstractRequest {
    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(uri, params, "default");
    }

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, ServerTypeEnum serverType) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(uri, params, "default", serverType);
    }

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(uri, params, null, null, merchantKey);
    }

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, String merchantKey, ServerTypeEnum serverType) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(uri, params, null, null, merchantKey, serverType);
    }

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, File file, String fileParam, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(uri, params, file, fileParam, merchantKey, null);
    }

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, File file, String fileParam, String merchantKey, ServerTypeEnum serverType) throws BaseAdaPayException {
        MerConfig config = Adapay.getConfig(merchantKey);
        if (config == null) {
            throw new BaseAdaPayException(FailureCode.CONFIG_EXCEPTION.getFailureCode(), "\u672a\u627e\u5230\u5bf9\u5e94" + merchantKey + "\u5546\u6237\u914d\u7f6e");
        }
        String apikey = config.getApiKey();
        if (!Adapay.prodMode) {
            apikey = config.getApiMockKey();
        }
        return AdapayRequest.requestAdapayCore((AbstractRequest.RequestMethod)AbstractRequest.RequestMethod.POST, (String)uri, params, (File)file, (String)fileParam, (String)config.getRSAPrivateKey(), (String)apikey, (ServerTypeEnum)serverType);
    }

    public static Map<String, Object> getRequestAdapay(String uri, Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(uri, params, "default");
    }

    public static Map<String, Object> getRequestAdapay(String uri, Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        MerConfig config = Adapay.getConfig(merchantKey);
        if (config == null) {
            throw new BaseAdaPayException(FailureCode.CONFIG_EXCEPTION.getFailureCode(), "\u672a\u627e\u5230\u5bf9\u5e94" + merchantKey + "\u7684\u5546\u6237\u914d\u7f6e");
        }
        String apikey = config.getApiKey();
        if (!Adapay.prodMode) {
            apikey = config.getApiMockKey();
        }
        return AdapayRequest.requestAdapayCore((AbstractRequest.RequestMethod)AbstractRequest.RequestMethod.GET, (String)uri, params, (String)config.getRSAPrivateKey(), (String)apikey);
    }
}

