/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider;

import cfca.sadk.org.bouncycastle.jce.exception.ExtCertPathBuilderException;
import cfca.sadk.org.bouncycastle.jce.provider.AnnotatedException;
import cfca.sadk.org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import cfca.sadk.org.bouncycastle.util.Selector;
import cfca.sadk.org.bouncycastle.x509.ExtendedPKIXBuilderParameters;
import cfca.sadk.org.bouncycastle.x509.X509AttributeCertStoreSelector;
import cfca.sadk.org.bouncycastle.x509.X509AttributeCertificate;
import cfca.sadk.org.bouncycastle.x509.X509CertStoreSelector;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class PKIXAttrCertPathBuilderSpi
extends CertPathBuilderSpi {
    private Exception certPathException;

    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection targets;
        if (!(params instanceof PKIXBuilderParameters) && !(params instanceof ExtendedPKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + ExtendedPKIXBuilderParameters.class.getName() + ".");
        }
        ExtendedPKIXBuilderParameters pkixParams = params instanceof ExtendedPKIXBuilderParameters ? (ExtendedPKIXBuilderParameters)params : (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance((PKIXBuilderParameters)params);
        ArrayList certPathList = new ArrayList();
        Selector certSelect = pkixParams.getTargetConstraints();
        if (!(certSelect instanceof X509AttributeCertStoreSelector)) {
            throw new CertPathBuilderException("TargetConstraints must be an instance of " + X509AttributeCertStoreSelector.class.getName() + " for " + this.getClass().getName() + " class.");
        }
        try {
            targets = CertPathValidatorUtilities.findCertificates((X509AttributeCertStoreSelector)certSelect, pkixParams.getStores());
        }
        catch (AnnotatedException e) {
            throw new ExtCertPathBuilderException("Error finding target attribute certificate.", e);
        }
        if (targets.isEmpty()) {
            throw new CertPathBuilderException("No attribute certificate found matching targetContraints.");
        }
        CertPathBuilderResult result = null;
        Iterator targetIter = targets.iterator();
        while (targetIter.hasNext() && result == null) {
            X509AttributeCertificate cert = (X509AttributeCertificate)targetIter.next();
            X509CertStoreSelector selector = new X509CertStoreSelector();
            Principal[] principals = cert.getIssuer().getPrincipals();
            HashSet issuers = new HashSet();
            for (int i = 0; i < principals.length; ++i) {
                try {
                    if (principals[i] instanceof X500Principal) {
                        selector.setSubject(((X500Principal)principals[i]).getEncoded());
                    }
                    issuers.addAll(CertPathValidatorUtilities.findCertificates(selector, pkixParams.getStores()));
                    issuers.addAll(CertPathValidatorUtilities.findCertificates(selector, pkixParams.getCertStores()));
                    continue;
                }
                catch (AnnotatedException e) {
                    throw new ExtCertPathBuilderException("Public key certificate for attribute certificate cannot be searched.", e);
                }
                catch (IOException e) {
                    throw new ExtCertPathBuilderException("cannot encode X500Principal.", e);
                }
            }
            if (issuers.isEmpty()) {
                throw new CertPathBuilderException("Public key certificate for attribute certificate cannot be found.");
            }
            Iterator it = issuers.iterator();
            while (it.hasNext() && result == null) {
                result = this.build(cert, (X509Certificate)it.next(), pkixParams, certPathList);
            }
        }
        if (result == null && this.certPathException != null) {
            throw new ExtCertPathBuilderException("Possible certificate chain could not be validated.", this.certPathException);
        }
        if (result == null && this.certPathException == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return result;
    }

    private CertPathBuilderResult build(X509AttributeCertificate attrCert, X509Certificate tbvCert, ExtendedPKIXBuilderParameters pkixParams, List tbvPath) {
        CertPathValidator validator;
        CertificateFactory cFact;
        if (tbvPath.contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getExcludedCerts().contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getMaxPathLength() != -1 && tbvPath.size() - 1 > pkixParams.getMaxPathLength()) {
            return null;
        }
        tbvPath.add(tbvCert);
        CertPathBuilderResult builderResult = null;
        try {
            cFact = CertificateFactory.getInstance("X.509", "BC");
            validator = CertPathValidator.getInstance("RFC3281", "BC");
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            if (CertPathValidatorUtilities.findTrustAnchor(tbvCert, pkixParams.getTrustAnchors(), pkixParams.getSigProvider()) != null) {
                PKIXCertPathValidatorResult result;
                CertPath certPath;
                try {
                    certPath = cFact.generateCertPath(tbvPath);
                }
                catch (Exception e) {
                    throw new AnnotatedException("Certification path could not be constructed from certificate list.", e);
                }
                try {
                    result = (PKIXCertPathValidatorResult)validator.validate(certPath, pkixParams);
                }
                catch (Exception e) {
                    throw new AnnotatedException("Certification path could not be validated.", e);
                }
                return new PKIXCertPathBuilderResult(certPath, result.getTrustAnchor(), result.getPolicyTree(), result.getPublicKey());
            }
            try {
                CertPathValidatorUtilities.addAdditionalStoresFromAltNames(tbvCert, pkixParams);
            }
            catch (CertificateParsingException e) {
                throw new AnnotatedException("No additional X.509 stores can be added from certificate locations.", e);
            }
            HashSet issuers = new HashSet();
            try {
                issuers.addAll(CertPathValidatorUtilities.findIssuerCerts(tbvCert, pkixParams));
            }
            catch (AnnotatedException e) {
                throw new AnnotatedException("Cannot find issuer certificate for certificate in certification path.", e);
            }
            if (issuers.isEmpty()) {
                throw new AnnotatedException("No issuer certificate for certificate in certification path found.");
            }
            Iterator it = issuers.iterator();
            while (it.hasNext() && builderResult == null) {
                X509Certificate issuer = (X509Certificate)it.next();
                if (issuer.getIssuerX500Principal().equals(issuer.getSubjectX500Principal())) continue;
                builderResult = this.build(attrCert, issuer, pkixParams, tbvPath);
            }
        }
        catch (AnnotatedException e) {
            this.certPathException = new AnnotatedException("No valid certification path could be build.", e);
        }
        if (builderResult == null) {
            tbvPath.remove(tbvCert);
        }
        return builderResult;
    }
}

