/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.operator.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.OperatorStreamException;
import com.timevale.tgtext.bouncycastle.operator.RawContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.RuntimeOperatorException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class JcaContentVerifierProviderBuilder {
    private com.timevale.tgtext.bouncycastle.operator.jcajce.a helper = new com.timevale.tgtext.bouncycastle.operator.jcajce.a(new DefaultJcaJceHelper());

    public JcaContentVerifierProviderBuilder setProvider(Provider provider) {
        this.helper = new com.timevale.tgtext.bouncycastle.operator.jcajce.a(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentVerifierProviderBuilder setProvider(String providerName) {
        this.helper = new com.timevale.tgtext.bouncycastle.operator.jcajce.a(new NamedJcaJceHelper(providerName));
        return this;
    }

    public ContentVerifierProvider build(X509CertificateHolder certHolder) throws OperatorCreationException, CertificateException {
        return this.build(this.helper.a(certHolder));
    }

    public ContentVerifierProvider build(final X509Certificate certificate) throws OperatorCreationException {
        JcaX509CertificateHolder certHolder;
        try {
            certHolder = new JcaX509CertificateHolder(certificate);
        }
        catch (CertificateEncodingException e2) {
            throw new OperatorCreationException("cannot process certificate: " + e2.getMessage(), e2);
        }
        return new ContentVerifierProvider(){
            private c d;

            @Override
            public boolean hasAssociatedCertificate() {
                return true;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    Signature sig = JcaContentVerifierProviderBuilder.this.helper.b(algorithm);
                    sig.initVerify(certificate.getPublicKey());
                    this.d = new c(sig);
                }
                catch (GeneralSecurityException e2) {
                    throw new OperatorCreationException("exception on setup: " + e2, e2);
                }
                Signature rawSig = JcaContentVerifierProviderBuilder.this.createRawSig(algorithm, certificate.getPublicKey());
                if (rawSig != null) {
                    return new a(algorithm, this.d, rawSig);
                }
                return new b(algorithm, this.d);
            }
        };
    }

    public ContentVerifierProvider build(final PublicKey publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return false;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                c stream = JcaContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                Signature rawSig = JcaContentVerifierProviderBuilder.this.createRawSig(algorithm, publicKey);
                if (rawSig != null) {
                    return new a(algorithm, stream, rawSig);
                }
                return new b(algorithm, stream);
            }
        };
    }

    private c createSignatureStream(AlgorithmIdentifier algorithm, PublicKey publicKey) throws OperatorCreationException {
        try {
            Signature sig = this.helper.b(algorithm);
            sig.initVerify(publicKey);
            return new c(sig);
        }
        catch (GeneralSecurityException e2) {
            throw new OperatorCreationException("exception on setup: " + e2, e2);
        }
    }

    private Signature createRawSig(AlgorithmIdentifier algorithm, PublicKey publicKey) {
        Signature rawSig;
        try {
            rawSig = this.helper.c(algorithm);
            if (rawSig != null) {
                rawSig.initVerify(publicKey);
            }
        }
        catch (Exception exception) {
            rawSig = null;
        }
        return rawSig;
    }

    private class c
    extends OutputStream {
        private Signature b;

        c(Signature sig) {
            this.b = sig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.b.update(bytes, off, len);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.b.update(bytes);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        @Override
        public void write(int b2) throws IOException {
            try {
                this.b.update((byte)b2);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        boolean a(byte[] expected) throws SignatureException {
            return this.b.verify(expected);
        }
    }

    private class a
    extends b
    implements RawContentVerifier {
        private Signature c;

        a(AlgorithmIdentifier algorithm, c stream, Signature rawSignature) {
            super(algorithm, stream);
            this.c = rawSignature;
        }

        @Override
        public boolean verify(byte[] digest, byte[] expected) {
            try {
                this.c.update(digest);
                return this.c.verify(expected);
            }
            catch (SignatureException e2) {
                throw new RuntimeOperatorException("exception obtaining raw signature: " + e2.getMessage(), e2);
            }
        }
    }

    private class b
    implements ContentVerifier {
        private c a;
        private AlgorithmIdentifier c;

        b(AlgorithmIdentifier algorithm, c stream) {
            this.c = algorithm;
            this.a = stream;
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.c;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.a == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.a;
        }

        @Override
        public boolean verify(byte[] expected) {
            try {
                return this.a.a(expected);
            }
            catch (SignatureException e2) {
                throw new RuntimeOperatorException("exception obtaining signature: " + e2.getMessage(), e2);
            }
        }
    }
}

