/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.tsp.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.Evidence;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampAndCRL;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampTokenEvidence;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampedData;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.bouncycastle.tsp.cms.ImprintDigestInvalidException;
import com.timevale.tgtext.bouncycastle.tsp.cms.b;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class CMSTimeStampedData {
    private TimeStampedData timeStampedData;
    private ContentInfo contentInfo;
    private b util;

    public CMSTimeStampedData(ContentInfo contentInfo) {
        this.initialize(contentInfo);
    }

    public CMSTimeStampedData(InputStream in) throws IOException {
        try {
            this.initialize(ContentInfo.getInstance(new ASN1InputStream(in).readObject()));
            return;
        }
        catch (ClassCastException e2) {
            throw new IOException("Malformed content: " + e2);
        }
        catch (IllegalArgumentException e3) {
            throw new IOException("Malformed content: " + e3);
        }
    }

    public CMSTimeStampedData(byte[] baseData) throws IOException {
        this(new ByteArrayInputStream(baseData));
    }

    private void initialize(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
        if (!CMSObjectIdentifiers.timestampedData.equals(contentInfo.getContentType())) {
            throw new IllegalArgumentException("Malformed content - type must be " + CMSObjectIdentifiers.timestampedData.getId());
        }
        this.timeStampedData = TimeStampedData.getInstance(contentInfo.getContent());
        this.util = new b(this.timeStampedData);
    }

    public byte[] calculateNextHash(DigestCalculator calculator) throws CMSException {
        return this.util.b(calculator);
    }

    public CMSTimeStampedData addTimeStamp(TimeStampToken token) throws CMSException {
        TimeStampAndCRL[] timeStamps = this.util.b();
        TimeStampAndCRL[] newTimeStamps = new TimeStampAndCRL[timeStamps.length + 1];
        System.arraycopy(timeStamps, 0, newTimeStamps, 0, timeStamps.length);
        newTimeStamps[timeStamps.length] = new TimeStampAndCRL(token.toCMSSignedData().getContentInfo());
        return new CMSTimeStampedData(new ContentInfo(CMSObjectIdentifiers.timestampedData, new TimeStampedData(this.timeStampedData.getDataUri(), this.timeStampedData.getMetaData(), this.timeStampedData.getContent(), new Evidence(new TimeStampTokenEvidence(newTimeStamps)))));
    }

    public byte[] getContent() {
        if (this.timeStampedData.getContent() != null) {
            return this.timeStampedData.getContent().getOctets();
        }
        return null;
    }

    public URI getDataUri() throws URISyntaxException {
        DERIA5String dataURI = this.timeStampedData.getDataUri();
        if (dataURI != null) {
            return new URI(dataURI.getString());
        }
        return null;
    }

    public String getFileName() {
        return this.util.c();
    }

    public String getMediaType() {
        return this.util.d();
    }

    public AttributeTable getOtherMetaData() {
        return this.util.e();
    }

    public TimeStampToken[] getTimeStampTokens() throws CMSException {
        return this.util.a();
    }

    public void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        this.util.a(calculator);
    }

    public DigestCalculator getMessageImprintDigestCalculator(DigestCalculatorProvider calculatorProvider) throws OperatorCreationException {
        return this.util.a(calculatorProvider);
    }

    public void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest) throws ImprintDigestInvalidException, CMSException {
        this.util.a(calculatorProvider, dataDigest);
    }

    public void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        this.util.a(calculatorProvider, dataDigest, timeStampToken);
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

