/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERGeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import java.util.Enumeration;

public class CrlID
extends ASN1Object {
    private DERIA5String crlUrl;
    private ASN1Integer crlNum;
    private ASN1GeneralizedTime crlTime;

    private CrlID(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        block5: while (e2.hasMoreElements()) {
            ASN1TaggedObject o2 = (ASN1TaggedObject)e2.nextElement();
            switch (o2.getTagNo()) {
                case 0: {
                    this.crlUrl = DERIA5String.getInstance(o2, true);
                    continue block5;
                }
                case 1: {
                    this.crlNum = ASN1Integer.getInstance(o2, true);
                    continue block5;
                }
                case 2: {
                    this.crlTime = DERGeneralizedTime.getInstance(o2, true);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + o2.getTagNo());
        }
    }

    public static CrlID getInstance(Object obj) {
        if (obj instanceof CrlID) {
            return (CrlID)obj;
        }
        if (obj != null) {
            return new CrlID(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DERIA5String getCrlUrl() {
        return this.crlUrl;
    }

    public ASN1Integer getCrlNum() {
        return this.crlNum;
    }

    public ASN1GeneralizedTime getCrlTime() {
        return this.crlTime;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.crlUrl != null) {
            v2.add(new DERTaggedObject(true, 0, this.crlUrl));
        }
        if (this.crlNum != null) {
            v2.add(new DERTaggedObject(true, 1, this.crlNum));
        }
        if (this.crlTime != null) {
            v2.add(new DERTaggedObject(true, 2, this.crlTime));
        }
        return new DERSequence(v2);
    }
}

