/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.shade.org.apache.http.Header;
import com.yeepay.shade.org.apache.http.HttpResponse;
import com.yeepay.shade.org.apache.http.annotation.Contract;
import com.yeepay.shade.org.apache.http.annotation.ThreadingBehavior;
import com.yeepay.shade.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.yeepay.shade.org.apache.http.protocol.HttpContext;
import com.yeepay.shade.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class YopConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        Header[] headers = response.getHeaders("Keep-Alive");
        if (null != headers && headers.length > 0) {
            String param = headers[0].getName();
            String value = headers[0].getValue();
            if (value != null && param.equalsIgnoreCase("timeout")) {
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 30000L;
    }
}

