/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class PolynomialGF2mSmallM {
    private GF2mField field;
    private int degree;
    private int[] coefficients;
    public static final char RANDOM_IRREDUCIBLE_POLYNOMIAL = 'I';

    public PolynomialGF2mSmallM(GF2mField field) {
        this.field = field;
        this.degree = -1;
        this.coefficients = new int[1];
    }

    public PolynomialGF2mSmallM(GF2mField field, int deg, char typeOfPolynomial, SecureRandom sr) {
        this.field = field;
        switch (typeOfPolynomial) {
            case 'I': {
                this.coefficients = this.createRandomIrreduciblePolynomial(deg, sr);
                break;
            }
            default: {
                throw new IllegalArgumentException(" Error: type " + typeOfPolynomial + " is not defined for GF2smallmPolynomial");
            }
        }
        this.computeDegree();
    }

    private int[] createRandomIrreduciblePolynomial(int deg, SecureRandom sr) {
        int[] nArray = new int[deg + 1];
        int[] resCoeff = nArray;
        nArray[deg] = 1;
        resCoeff[0] = this.field.getRandomNonZeroElement(sr);
        for (int i2 = 1; i2 < deg; ++i2) {
            resCoeff[i2] = this.field.getRandomElement(sr);
        }
        while (!this.isIrreducible(resCoeff)) {
            int n2 = RandUtils.nextInt(sr, deg);
            if (n2 == 0) {
                resCoeff[0] = this.field.getRandomNonZeroElement(sr);
                continue;
            }
            resCoeff[n2] = this.field.getRandomElement(sr);
        }
        return resCoeff;
    }

    public PolynomialGF2mSmallM(GF2mField field, int degree) {
        this.field = field;
        this.degree = degree;
        this.coefficients = new int[degree + 1];
        this.coefficients[degree] = 1;
    }

    public PolynomialGF2mSmallM(GF2mField field, int[] coeffs) {
        this.field = field;
        this.coefficients = PolynomialGF2mSmallM.normalForm(coeffs);
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(GF2mField field, byte[] enc) {
        int d2;
        this.field = field;
        int count = 1;
        for (d2 = 8; field.getDegree() > d2; d2 += 8) {
            ++count;
        }
        if (enc.length % count != 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.coefficients = new int[enc.length / count];
        count = 0;
        for (int i2 = 0; i2 < this.coefficients.length; ++i2) {
            for (int j2 = 0; j2 < d2; j2 += 8) {
                int n2 = i2;
                this.coefficients[n2] = this.coefficients[n2] ^ (enc[count++] & 0xFF) << j2;
            }
            if (this.field.isElementOfThisField(this.coefficients[i2])) continue;
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        if (this.coefficients.length != 1 && this.coefficients[this.coefficients.length - 1] == 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(PolynomialGF2mSmallM other) {
        this.field = other.field;
        this.degree = other.degree;
        this.coefficients = IntUtils.clone(other.coefficients);
    }

    public PolynomialGF2mSmallM(GF2mVector vect) {
        this(vect.getField(), vect.getIntArrayForm());
    }

    public int getDegree() {
        int d2 = this.coefficients.length - 1;
        if (this.coefficients[d2] == 0) {
            return -1;
        }
        return d2;
    }

    public int getHeadCoefficient() {
        if (this.degree == -1) {
            return 0;
        }
        return this.coefficients[this.degree];
    }

    private static int headCoefficient(int[] a2) {
        int degree = PolynomialGF2mSmallM.computeDegree(a2);
        if (degree == -1) {
            return 0;
        }
        return a2[degree];
    }

    public int getCoefficient(int index) {
        if (index < 0 || index > this.degree) {
            return 0;
        }
        return this.coefficients[index];
    }

    public byte[] getEncoded() {
        int d2;
        int count = 1;
        for (d2 = 8; this.field.getDegree() > d2; d2 += 8) {
            ++count;
        }
        byte[] res = new byte[this.coefficients.length * count];
        count = 0;
        for (int i2 = 0; i2 < this.coefficients.length; ++i2) {
            for (int j2 = 0; j2 < d2; j2 += 8) {
                res[count++] = (byte)(this.coefficients[i2] >>> j2);
            }
        }
        return res;
    }

    public int evaluateAt(int e2) {
        int result = this.coefficients[this.degree];
        for (int i2 = this.degree - 1; i2 >= 0; --i2) {
            result = this.field.mult(result, e2) ^ this.coefficients[i2];
        }
        return result;
    }

    public PolynomialGF2mSmallM add(PolynomialGF2mSmallM addend) {
        int[] resultCoeff = this.add(this.coefficients, addend.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public void addToThis(PolynomialGF2mSmallM addend) {
        this.coefficients = this.add(this.coefficients, addend.coefficients);
        this.computeDegree();
    }

    private int[] add(int[] a2, int[] b2) {
        int[] addend;
        int[] result;
        if (a2.length < b2.length) {
            result = new int[b2.length];
            System.arraycopy(b2, 0, result, 0, b2.length);
            addend = a2;
        } else {
            result = new int[a2.length];
            System.arraycopy(a2, 0, result, 0, a2.length);
            addend = b2;
        }
        for (int i2 = addend.length - 1; i2 >= 0; --i2) {
            result[i2] = this.field.add(result[i2], addend[i2]);
        }
        return result;
    }

    public PolynomialGF2mSmallM addMonomial(int degree) {
        int[] nArray = new int[degree + 1];
        int[] monomial = nArray;
        nArray[degree] = 1;
        int[] resultCoeff = this.add(this.coefficients, monomial);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM multWithElement(int element) {
        if (!this.field.isElementOfThisField(element)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        int[] resultCoeff = this.multWithElement(this.coefficients, element);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public void multThisWithElement(int element) {
        if (!this.field.isElementOfThisField(element)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        this.coefficients = this.multWithElement(this.coefficients, element);
        this.computeDegree();
    }

    private int[] multWithElement(int[] a2, int element) {
        int degree = PolynomialGF2mSmallM.computeDegree(a2);
        if (degree == -1 || element == 0) {
            return new int[1];
        }
        if (element == 1) {
            return IntUtils.clone(a2);
        }
        int[] result = new int[degree + 1];
        for (int i2 = degree; i2 >= 0; --i2) {
            result[i2] = this.field.mult(a2[i2], element);
        }
        return result;
    }

    public PolynomialGF2mSmallM multWithMonomial(int k2) {
        int[] resultCoeff = PolynomialGF2mSmallM.multWithMonomial(this.coefficients, k2);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private static int[] multWithMonomial(int[] a2, int k2) {
        int d2 = PolynomialGF2mSmallM.computeDegree(a2);
        if (d2 == -1) {
            return new int[1];
        }
        int[] result = new int[d2 + k2 + 1];
        System.arraycopy(a2, 0, result, k2, d2 + 1);
        return result;
    }

    public PolynomialGF2mSmallM[] div(PolynomialGF2mSmallM f2) {
        int[][] resultCoeffs = this.div(this.coefficients, f2.coefficients);
        return new PolynomialGF2mSmallM[]{new PolynomialGF2mSmallM(this.field, resultCoeffs[0]), new PolynomialGF2mSmallM(this.field, resultCoeffs[1])};
    }

    private int[][] div(int[] a2, int[] f2) {
        int df2 = PolynomialGF2mSmallM.computeDegree(f2);
        int da2 = PolynomialGF2mSmallM.computeDegree(a2) + 1;
        if (df2 == -1) {
            throw new ArithmeticException("Division by zero.");
        }
        int[][] nArrayArray = new int[2][];
        int[][] result = nArrayArray;
        nArrayArray[0] = new int[1];
        result[1] = new int[da2];
        int hc = PolynomialGF2mSmallM.headCoefficient(f2);
        hc = this.field.inverse(hc);
        result[0][0] = 0;
        System.arraycopy(a2, 0, result[1], 0, result[1].length);
        while (df2 <= PolynomialGF2mSmallM.computeDegree(result[1])) {
            int[] nArray = new int[1];
            int[] coeff = nArray;
            nArray[0] = this.field.mult(PolynomialGF2mSmallM.headCoefficient(result[1]), hc);
            int[] q2 = this.multWithElement(f2, coeff[0]);
            int n2 = PolynomialGF2mSmallM.computeDegree(result[1]) - df2;
            q2 = PolynomialGF2mSmallM.multWithMonomial(q2, n2);
            coeff = PolynomialGF2mSmallM.multWithMonomial(coeff, n2);
            result[0] = this.add(coeff, result[0]);
            result[1] = this.add(q2, result[1]);
        }
        return result;
    }

    public PolynomialGF2mSmallM gcd(PolynomialGF2mSmallM f2) {
        int[] resultCoeff = this.gcd(this.coefficients, f2.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] gcd(int[] f2, int[] g2) {
        int[] a2 = f2;
        int[] b2 = g2;
        if (PolynomialGF2mSmallM.computeDegree(a2) == -1) {
            return b2;
        }
        while (PolynomialGF2mSmallM.computeDegree(b2) != -1) {
            int[] c2 = this.mod(a2, b2);
            a2 = new int[b2.length];
            System.arraycopy(b2, 0, a2, 0, a2.length);
            b2 = new int[c2.length];
            System.arraycopy(c2, 0, b2, 0, b2.length);
        }
        int coeff = this.field.inverse(PolynomialGF2mSmallM.headCoefficient(a2));
        return this.multWithElement(a2, coeff);
    }

    public PolynomialGF2mSmallM multiply(PolynomialGF2mSmallM factor) {
        int[] resultCoeff = this.multiply(this.coefficients, factor.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] multiply(int[] a2, int[] b2) {
        int[] result;
        int[] mult2;
        int[] mult1;
        if (PolynomialGF2mSmallM.computeDegree(a2) < PolynomialGF2mSmallM.computeDegree(b2)) {
            mult1 = b2;
            mult2 = a2;
        } else {
            mult1 = a2;
            mult2 = b2;
        }
        mult1 = PolynomialGF2mSmallM.normalForm(mult1);
        mult2 = PolynomialGF2mSmallM.normalForm(mult2);
        if (mult2.length == 1) {
            return this.multWithElement(mult1, mult2[0]);
        }
        int d2 = mult2.length;
        int d1 = mult1.length;
        if (d2 != d1) {
            int[] res1 = new int[d2];
            int[] res2 = new int[d1 - d2];
            System.arraycopy(mult1, 0, res1, 0, res1.length);
            System.arraycopy(mult1, d2, res2, 0, res2.length);
            res1 = this.multiply(res1, mult2);
            res2 = this.multiply(res2, mult2);
            res2 = PolynomialGF2mSmallM.multWithMonomial(res2, d2);
            result = this.add(res1, res2);
        } else {
            d2 = d1 + 1 >>> 1;
            int d3 = d1 - d2;
            int[] firstPartMult1 = new int[d2];
            int[] firstPartMult2 = new int[d2];
            int[] secondPartMult1 = new int[d3];
            int[] secondPartMult2 = new int[d3];
            System.arraycopy(mult1, 0, firstPartMult1, 0, firstPartMult1.length);
            System.arraycopy(mult1, d2, secondPartMult1, 0, secondPartMult1.length);
            System.arraycopy(mult2, 0, firstPartMult2, 0, firstPartMult2.length);
            System.arraycopy(mult2, d2, secondPartMult2, 0, secondPartMult2.length);
            int[] helpPoly1 = this.add(firstPartMult1, secondPartMult1);
            int[] helpPoly2 = this.add(firstPartMult2, secondPartMult2);
            int[] res1 = this.multiply(firstPartMult1, firstPartMult2);
            int[] res2 = this.multiply(helpPoly1, helpPoly2);
            int[] res3 = this.multiply(secondPartMult1, secondPartMult2);
            res2 = this.add(res2, res1);
            res2 = this.add(res2, res3);
            res3 = PolynomialGF2mSmallM.multWithMonomial(res3, d2);
            result = this.add(res2, res3);
            result = PolynomialGF2mSmallM.multWithMonomial(result, d2);
            result = this.add(result, res1);
        }
        return result;
    }

    private boolean isIrreducible(int[] a2) {
        if (a2[0] == 0) {
            return false;
        }
        int d2 = PolynomialGF2mSmallM.computeDegree(a2) >> 1;
        int[] u2 = new int[]{0, 1};
        int[] Y = new int[]{0, 1};
        int fieldDegree = this.field.getDegree();
        for (int i2 = 0; i2 < d2; ++i2) {
            for (int j2 = fieldDegree - 1; j2 >= 0; --j2) {
                u2 = this.modMultiply(u2, u2, a2);
            }
            int[] g2 = this.gcd(this.add(u2 = PolynomialGF2mSmallM.normalForm(u2), Y), a2);
            if (PolynomialGF2mSmallM.computeDegree(g2) == 0) continue;
            return false;
        }
        return true;
    }

    public PolynomialGF2mSmallM mod(PolynomialGF2mSmallM f2) {
        int[] resultCoeff = this.mod(this.coefficients, f2.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] mod(int[] a2, int[] f2) {
        int df2 = PolynomialGF2mSmallM.computeDegree(f2);
        if (df2 == -1) {
            throw new ArithmeticException("Division by zero");
        }
        int[] result = new int[a2.length];
        int hc = PolynomialGF2mSmallM.headCoefficient(f2);
        hc = this.field.inverse(hc);
        System.arraycopy(a2, 0, result, 0, result.length);
        while (df2 <= PolynomialGF2mSmallM.computeDegree(result)) {
            int coeff = this.field.mult(PolynomialGF2mSmallM.headCoefficient(result), hc);
            int[] q2 = PolynomialGF2mSmallM.multWithMonomial(f2, PolynomialGF2mSmallM.computeDegree(result) - df2);
            q2 = this.multWithElement(q2, coeff);
            result = this.add(q2, result);
        }
        return result;
    }

    public PolynomialGF2mSmallM modMultiply(PolynomialGF2mSmallM a2, PolynomialGF2mSmallM b2) {
        int[] resultCoeff = this.modMultiply(this.coefficients, a2.coefficients, b2.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM modSquareMatrix(PolynomialGF2mSmallM[] matrix) {
        int i2;
        int length = matrix.length;
        int[] resultCoeff = new int[length];
        int[] thisSquare = new int[length];
        for (i2 = 0; i2 < this.coefficients.length; ++i2) {
            thisSquare[i2] = this.field.mult(this.coefficients[i2], this.coefficients[i2]);
        }
        for (i2 = 0; i2 < length; ++i2) {
            for (int j2 = 0; j2 < length; ++j2) {
                if (i2 >= matrix[j2].coefficients.length) continue;
                int scalarTerm = this.field.mult(matrix[j2].coefficients[i2], thisSquare[j2]);
                resultCoeff[i2] = this.field.add(resultCoeff[i2], scalarTerm);
            }
        }
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] modMultiply(int[] a2, int[] b2, int[] g2) {
        return this.mod(this.multiply(a2, b2), g2);
    }

    public PolynomialGF2mSmallM modSquareRoot(PolynomialGF2mSmallM a2) {
        int[] resultCoeff = IntUtils.clone(this.coefficients);
        int[] help = this.modMultiply(resultCoeff, resultCoeff, a2.coefficients);
        while (!PolynomialGF2mSmallM.isEqual(help, this.coefficients)) {
            resultCoeff = PolynomialGF2mSmallM.normalForm(help);
            help = this.modMultiply(resultCoeff, resultCoeff, a2.coefficients);
        }
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM modSquareRootMatrix(PolynomialGF2mSmallM[] matrix) {
        int i2;
        int length = matrix.length;
        int[] resultCoeff = new int[length];
        for (i2 = 0; i2 < length; ++i2) {
            for (int j2 = 0; j2 < length; ++j2) {
                if (i2 >= matrix[j2].coefficients.length || j2 >= this.coefficients.length) continue;
                int scalarTerm = this.field.mult(matrix[j2].coefficients[i2], this.coefficients[j2]);
                resultCoeff[i2] = this.field.add(resultCoeff[i2], scalarTerm);
            }
        }
        for (i2 = 0; i2 < length; ++i2) {
            resultCoeff[i2] = this.field.sqRoot(resultCoeff[i2]);
        }
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM modDiv(PolynomialGF2mSmallM divisor, PolynomialGF2mSmallM modulus) {
        int[] resultCoeff = this.modDiv(this.coefficients, divisor.coefficients, modulus.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    private int[] modDiv(int[] a2, int[] b2, int[] g2) {
        int[] r0 = PolynomialGF2mSmallM.normalForm(g2);
        int[] r1 = this.mod(b2, g2);
        int[] s0 = new int[]{0};
        int[] s1 = this.mod(a2, g2);
        while (PolynomialGF2mSmallM.computeDegree(r1) != -1) {
            int[][] q2 = this.div(r0, r1);
            r0 = PolynomialGF2mSmallM.normalForm(r1);
            r1 = PolynomialGF2mSmallM.normalForm(q2[1]);
            int[] s2 = this.add(s0, this.modMultiply(q2[0], s1, g2));
            s0 = PolynomialGF2mSmallM.normalForm(s1);
            s1 = PolynomialGF2mSmallM.normalForm(s2);
        }
        int hc = PolynomialGF2mSmallM.headCoefficient(r0);
        s0 = this.multWithElement(s0, this.field.inverse(hc));
        return s0;
    }

    public PolynomialGF2mSmallM modInverse(PolynomialGF2mSmallM a2) {
        int[] unit = new int[]{1};
        int[] resultCoeff = this.modDiv(unit, this.coefficients, a2.coefficients);
        return new PolynomialGF2mSmallM(this.field, resultCoeff);
    }

    public PolynomialGF2mSmallM[] modPolynomialToFracton(PolynomialGF2mSmallM g2) {
        int dg2 = g2.degree >> 1;
        int[] a0 = PolynomialGF2mSmallM.normalForm(g2.coefficients);
        int[] a1 = this.mod(this.coefficients, g2.coefficients);
        int[] b0 = new int[]{0};
        int[] b1 = new int[]{1};
        while (PolynomialGF2mSmallM.computeDegree(a1) > dg2) {
            int[][] q2 = this.div(a0, a1);
            a0 = a1;
            a1 = q2[1];
            int[] b2 = this.add(b0, this.modMultiply(q2[0], b1, g2.coefficients));
            b0 = b1;
            b1 = b2;
        }
        return new PolynomialGF2mSmallM[]{new PolynomialGF2mSmallM(this.field, a1), new PolynomialGF2mSmallM(this.field, b1)};
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof PolynomialGF2mSmallM)) {
            return false;
        }
        PolynomialGF2mSmallM p2 = (PolynomialGF2mSmallM)other;
        return this.field.equals(p2.field) && this.degree == p2.degree && PolynomialGF2mSmallM.isEqual(this.coefficients, p2.coefficients);
    }

    private static boolean isEqual(int[] a2, int[] b2) {
        int db2;
        int da2 = PolynomialGF2mSmallM.computeDegree(a2);
        if (da2 != (db2 = PolynomialGF2mSmallM.computeDegree(b2))) {
            return false;
        }
        for (int i2 = 0; i2 <= da2; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.field.hashCode();
        for (int j2 = 0; j2 < this.coefficients.length; ++j2) {
            hash = hash * 31 + this.coefficients[j2];
        }
        return hash;
    }

    public String toString() {
        String str = " Polynomial over " + this.field.toString() + ": \n";
        for (int i2 = 0; i2 < this.coefficients.length; ++i2) {
            str = str + this.field.elementToStr(this.coefficients[i2]) + "Y^" + i2 + "+";
        }
        str = str + ";";
        return str;
    }

    private void computeDegree() {
        this.degree = this.coefficients.length - 1;
        while (this.degree >= 0 && this.coefficients[this.degree] == 0) {
            --this.degree;
        }
    }

    private static int computeDegree(int[] a2) {
        int degree;
        for (degree = a2.length - 1; degree >= 0 && a2[degree] == 0; --degree) {
        }
        return degree;
    }

    private static int[] normalForm(int[] a2) {
        int d2 = PolynomialGF2mSmallM.computeDegree(a2);
        if (d2 == -1) {
            return new int[1];
        }
        if (a2.length == d2 + 1) {
            return IntUtils.clone(a2);
        }
        int[] result = new int[d2 + 1];
        System.arraycopy(a2, 0, result, 0, d2 + 1);
        return result;
    }
}

