/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.eac.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.eac.ECDSAPublicKey;
import com.timevale.tgtext.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.timevale.tgtext.bouncycastle.asn1.eac.RSAPublicKey;
import com.timevale.tgtext.bouncycastle.eac.EACException;
import com.timevale.tgtext.bouncycastle.eac.jcajce.a;
import com.timevale.tgtext.bouncycastle.eac.jcajce.b;
import com.timevale.tgtext.bouncycastle.eac.jcajce.c;
import com.timevale.tgtext.bouncycastle.eac.jcajce.d;
import com.timevale.tgtext.bouncycastle.jce.spec.ECParameterSpec;
import com.timevale.tgtext.bouncycastle.jce.spec.ECPublicKeySpec;
import com.timevale.tgtext.bouncycastle.math.ec.ECCurve;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class JcaPublicKeyConverter {
    private b helper = new a();

    public JcaPublicKeyConverter setProvider(String providerName) {
        this.helper = new c(providerName);
        return this;
    }

    public JcaPublicKeyConverter setProvider(Provider provider) {
        this.helper = new d(provider);
        return this;
    }

    public PublicKey getKey(PublicKeyDataObject publicKeyDataObject) throws EACException, InvalidKeySpecException {
        if (publicKeyDataObject.getUsage().on(EACObjectIdentifiers.id_TA_ECDSA)) {
            return this.getECPublicKeyPublicKey((ECDSAPublicKey)publicKeyDataObject);
        }
        RSAPublicKey pubKey = (RSAPublicKey)publicKeyDataObject;
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(pubKey.getModulus(), pubKey.getPublicExponent());
        try {
            KeyFactory factk = this.helper.a("RSA");
            return factk.generatePublic(pubKeySpec);
        }
        catch (NoSuchProviderException e2) {
            throw new EACException("cannot find provider: " + e2.getMessage(), e2);
        }
        catch (NoSuchAlgorithmException e3) {
            throw new EACException("cannot find algorithm ECDSA: " + e3.getMessage(), e3);
        }
    }

    private PublicKey getECPublicKeyPublicKey(ECDSAPublicKey key) throws EACException, InvalidKeySpecException {
        KeyFactory factk;
        ECParameterSpec spec = this.getParams(key);
        ECCurve curve = spec.getCurve();
        com.timevale.tgtext.bouncycastle.math.ec.ECPoint point = curve.decodePoint(key.getPublicPointY());
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, spec);
        try {
            factk = this.helper.a("ECDSA");
        }
        catch (NoSuchProviderException e2) {
            throw new EACException("cannot find provider: " + e2.getMessage(), e2);
        }
        catch (NoSuchAlgorithmException e3) {
            throw new EACException("cannot find algorithm ECDSA: " + e3.getMessage(), e3);
        }
        return factk.generatePublic(pubKeySpec);
    }

    private ECParameterSpec getParams(ECDSAPublicKey key) {
        if (!key.hasParameters()) {
            throw new IllegalArgumentException("Public key does not contains EC Params");
        }
        BigInteger p2 = key.getPrimeModulusP();
        ECCurve.Fp curve = new ECCurve.Fp(p2, key.getFirstCoefA(), key.getSecondCoefB());
        com.timevale.tgtext.bouncycastle.math.ec.ECPoint G = curve.decodePoint(key.getBasePointG());
        BigInteger order = key.getOrderOfBasePointR();
        BigInteger coFactor = key.getCofactorF();
        ECParameterSpec ecspec = new ECParameterSpec(curve, G, order, coFactor);
        return ecspec;
    }

    public PublicKeyDataObject getPublicKeyDataObject(ASN1ObjectIdentifier usage, PublicKey publicKey) {
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey pubKey = (java.security.interfaces.RSAPublicKey)publicKey;
            return new RSAPublicKey(usage, pubKey.getModulus(), pubKey.getPublicExponent());
        }
        ECPublicKey pubKey = (ECPublicKey)publicKey;
        java.security.spec.ECParameterSpec params = pubKey.getParams();
        return new ECDSAPublicKey(usage, ((ECFieldFp)params.getCurve().getField()).getP(), params.getCurve().getA(), params.getCurve().getB(), JcaPublicKeyConverter.convertPoint(JcaPublicKeyConverter.convertCurve(params.getCurve()), params.getGenerator(), false).getEncoded(), params.getOrder(), JcaPublicKeyConverter.convertPoint(JcaPublicKeyConverter.convertCurve(params.getCurve()), pubKey.getW(), false).getEncoded(), params.getCofactor());
    }

    private static com.timevale.tgtext.bouncycastle.math.ec.ECPoint convertPoint(ECCurve curve, ECPoint point, boolean withCompression) {
        return curve.createPoint(point.getAffineX(), point.getAffineY(), withCompression);
    }

    private static ECCurve convertCurve(EllipticCurve ec2) {
        ECField field = ec2.getField();
        BigInteger a2 = ec2.getA();
        BigInteger b2 = ec2.getB();
        if (field instanceof ECFieldFp) {
            return new ECCurve.Fp(((ECFieldFp)field).getP(), a2, b2);
        }
        throw new IllegalStateException("not implemented yet!!!");
    }
}

