/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;

public class AESLightEngine
implements BlockCipher {
    private static final byte[] S = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118, -54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64, -73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21, 4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117, 9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124, 83, -47, 0, -19, 32, -4, -79, 91, 106, -53, -66, 57, 74, 76, 88, -49, -48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88, 81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46, -51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115, 96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37, -32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121, -25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8, -70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118, 112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98, -31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33, -116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
    private static final byte[] Si = new byte[]{82, 9, 106, -43, 48, 54, -91, 56, -65, 64, -93, -98, -127, -13, -41, -5, 124, -29, 57, -126, -101, 47, -1, -121, 52, -114, 67, 68, -60, -34, -23, -53, 84, 123, -108, 50, -90, -62, 35, 61, -18, 76, -107, 11, 66, -6, -61, 78, 8, 46, -95, 102, 40, -39, 36, -78, 118, 91, -94, 73, 109, -117, -47, 37, 114, -8, -10, 100, -122, 104, -104, 22, -44, -92, 92, -52, 93, 101, -74, -110, 108, 112, 72, 80, -3, -19, -71, -38, 94, 21, 70, 87, -89, -115, -99, -124, -112, -40, -85, 0, -116, -68, -45, 10, -9, -28, 88, 5, -72, -77, 69, 6, -48, 44, 30, -113, -54, 63, 15, 2, -63, -81, -67, 3, 1, 19, -118, 107, 58, -111, 17, 65, 79, 103, -36, -22, -105, -14, -49, -50, -16, -76, -26, 115, -106, -84, 116, 34, -25, -83, 53, -123, -30, -7, 55, -24, 28, 117, -33, 110, 71, -15, 26, 113, 29, 41, -59, -119, 111, -73, 98, 14, -86, 24, -66, 27, -4, 86, 62, 75, -58, -46, 121, 32, -102, -37, -64, -2, 120, -51, 90, -12, 31, -35, -88, 51, -120, 7, -57, 49, -79, 18, 16, 89, 39, -128, -20, 95, 96, 81, 127, -87, 25, -75, 74, 13, 45, -27, 122, -97, -109, -55, -100, -17, -96, -32, 59, 77, -82, 42, -11, -80, -56, -21, -69, 60, -125, 83, -103, 97, 23, 43, 4, 126, -70, 119, -42, 38, -31, 105, 20, 99, 85, 33, 12, 125};
    private static final int[] rcon = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
    private static final int m1 = -2139062144;
    private static final int m2 = 0x7F7F7F7F;
    private static final int m3 = 27;
    private int ROUNDS;
    private int[][] WorkingKey = null;
    private int C0;
    private int C1;
    private int C2;
    private int C3;
    private boolean forEncryption;
    private static final int BLOCK_SIZE = 16;

    private static int shift(int r2, int shift) {
        return r2 >>> shift | r2 << -shift;
    }

    private static int FFmulX(int x2) {
        return (x2 & 0x7F7F7F7F) << 1 ^ ((x2 & 0x80808080) >>> 7) * 27;
    }

    private static int mcol(int x2) {
        int f2 = AESLightEngine.FFmulX(x2);
        return f2 ^ AESLightEngine.shift(x2 ^ f2, 8) ^ AESLightEngine.shift(x2, 16) ^ AESLightEngine.shift(x2, 24);
    }

    private static int inv_mcol(int x2) {
        int f2 = AESLightEngine.FFmulX(x2);
        int f4 = AESLightEngine.FFmulX(f2);
        int f8 = AESLightEngine.FFmulX(f4);
        int f9 = x2 ^ f8;
        return f2 ^ f4 ^ f8 ^ AESLightEngine.shift(f2 ^ f9, 8) ^ AESLightEngine.shift(f4 ^ f9, 16) ^ AESLightEngine.shift(f9, 24);
    }

    private static int subWord(int x2) {
        return S[x2 & 0xFF] & 0xFF | (S[x2 >> 8 & 0xFF] & 0xFF) << 8 | (S[x2 >> 16 & 0xFF] & 0xFF) << 16 | S[x2 >>> 24] << 24;
    }

    private int[][] generateWorkingKey(byte[] key, boolean forEncryption) {
        int KC = key.length / 4;
        if (KC != 4 && KC != 6 && KC != 8 || KC << 2 != key.length) {
            throw new IllegalArgumentException("Key length not 128/192/256 bits.");
        }
        this.ROUNDS = KC + 6;
        int[][] W = new int[this.ROUNDS + 1][4];
        int t2 = 0;
        int i2 = 0;
        while (i2 < key.length) {
            W[t2 >> 2][t2 & 3] = key[i2] & 0xFF | (key[i2 + 1] & 0xFF) << 8 | (key[i2 + 2] & 0xFF) << 16 | key[i2 + 3] << 24;
            i2 += 4;
            ++t2;
        }
        int k2 = this.ROUNDS + 1 << 2;
        for (i2 = KC; i2 < k2; ++i2) {
            int temp = W[i2 - 1 >> 2][i2 - 1 & 3];
            if (i2 % KC == 0) {
                temp = AESLightEngine.subWord(AESLightEngine.shift(temp, 8)) ^ rcon[i2 / KC - 1];
            } else if (KC > 6 && i2 % KC == 4) {
                temp = AESLightEngine.subWord(temp);
            }
            W[i2 >> 2][i2 & 3] = W[i2 - KC >> 2][i2 - KC & 3] ^ temp;
        }
        if (!forEncryption) {
            for (int j2 = 1; j2 < this.ROUNDS; ++j2) {
                for (i2 = 0; i2 < 4; ++i2) {
                    W[j2][i2] = AESLightEngine.inv_mcol(W[j2][i2]);
                }
            }
        }
        return W;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.WorkingKey = this.generateWorkingKey(((KeyParameter)params).getKey(), forEncryption);
            this.forEncryption = forEncryption;
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to AES init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.WorkingKey == null) {
            throw new IllegalStateException("AES engine not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.forEncryption) {
            this.unpackBlock(in, inOff);
            this.encryptBlock(this.WorkingKey);
            this.packBlock(out, outOff);
        } else {
            this.unpackBlock(in, inOff);
            this.decryptBlock(this.WorkingKey);
            this.packBlock(out, outOff);
        }
        return 16;
    }

    @Override
    public void reset() {
    }

    private void unpackBlock(byte[] bytes, int off) {
        int index = off;
        this.C0 = bytes[off] & 0xFF;
        int n2 = ++index;
        this.C0 |= (bytes[n2] & 0xFF) << 8;
        int n3 = ++index;
        this.C0 |= (bytes[n3] & 0xFF) << 16;
        int n4 = ++index;
        this.C0 |= bytes[n4] << 24;
        int n5 = ++index;
        this.C1 = bytes[n5] & 0xFF;
        int n6 = ++index;
        this.C1 |= (bytes[n6] & 0xFF) << 8;
        int n7 = ++index;
        this.C1 |= (bytes[n7] & 0xFF) << 16;
        int n8 = ++index;
        this.C1 |= bytes[n8] << 24;
        int n9 = ++index;
        this.C2 = bytes[n9] & 0xFF;
        int n10 = ++index;
        this.C2 |= (bytes[n10] & 0xFF) << 8;
        int n11 = ++index;
        this.C2 |= (bytes[n11] & 0xFF) << 16;
        int n12 = ++index;
        this.C2 |= bytes[n12] << 24;
        int n13 = ++index;
        this.C3 = bytes[n13] & 0xFF;
        int n14 = ++index;
        this.C3 |= (bytes[n14] & 0xFF) << 8;
        int n15 = ++index;
        this.C3 |= (bytes[n15] & 0xFF) << 16;
        this.C3 |= bytes[++index] << 24;
    }

    private void packBlock(byte[] bytes, int off) {
        int index = off;
        bytes[off] = (byte)this.C0;
        int n2 = ++index;
        bytes[n2] = (byte)(this.C0 >> 8);
        int n3 = ++index;
        bytes[n3] = (byte)(this.C0 >> 16);
        int n4 = ++index;
        bytes[n4] = this.C0 >> 24;
        int n5 = ++index;
        bytes[n5] = (byte)this.C1;
        int n6 = ++index;
        bytes[n6] = (byte)(this.C1 >> 8);
        int n7 = ++index;
        bytes[n7] = (byte)(this.C1 >> 16);
        int n8 = ++index;
        bytes[n8] = this.C1 >> 24;
        int n9 = ++index;
        bytes[n9] = (byte)this.C2;
        int n10 = ++index;
        bytes[n10] = (byte)(this.C2 >> 8);
        int n11 = ++index;
        bytes[n11] = (byte)(this.C2 >> 16);
        int n12 = ++index;
        bytes[n12] = this.C2 >> 24;
        int n13 = ++index;
        bytes[n13] = (byte)this.C3;
        int n14 = ++index;
        bytes[n14] = (byte)(this.C3 >> 8);
        int n15 = ++index;
        bytes[n15] = (byte)(this.C3 >> 16);
        bytes[++index] = this.C3 >> 24;
    }

    private void encryptBlock(int[][] KW) {
        int r3;
        int r2;
        int r1;
        int r0;
        this.C0 ^= KW[0][0];
        this.C1 ^= KW[0][1];
        this.C2 ^= KW[0][2];
        this.C3 ^= KW[0][3];
        int r4 = 1;
        while (r4 < this.ROUNDS - 1) {
            r0 = AESLightEngine.mcol(S[this.C0 & 0xFF] & 0xFF ^ (S[this.C1 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C3 >>> 24] << 24) ^ KW[r4][0];
            r1 = AESLightEngine.mcol(S[this.C1 & 0xFF] & 0xFF ^ (S[this.C2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C0 >>> 24] << 24) ^ KW[r4][1];
            r2 = AESLightEngine.mcol(S[this.C2 & 0xFF] & 0xFF ^ (S[this.C3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C0 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C1 >>> 24] << 24) ^ KW[r4][2];
            r3 = AESLightEngine.mcol(S[this.C3 & 0xFF] & 0xFF ^ (S[this.C0 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C1 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C2 >>> 24] << 24) ^ KW[r4++][3];
            this.C0 = AESLightEngine.mcol(S[r0 & 0xFF] & 0xFF ^ (S[r1 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r3 >>> 24] << 24) ^ KW[r4][0];
            this.C1 = AESLightEngine.mcol(S[r1 & 0xFF] & 0xFF ^ (S[r2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r0 >>> 24] << 24) ^ KW[r4][1];
            this.C2 = AESLightEngine.mcol(S[r2 & 0xFF] & 0xFF ^ (S[r3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r0 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r1 >>> 24] << 24) ^ KW[r4][2];
            this.C3 = AESLightEngine.mcol(S[r3 & 0xFF] & 0xFF ^ (S[r0 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r1 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r2 >>> 24] << 24) ^ KW[r4++][3];
        }
        r0 = AESLightEngine.mcol(S[this.C0 & 0xFF] & 0xFF ^ (S[this.C1 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C3 >>> 24] << 24) ^ KW[r4][0];
        r1 = AESLightEngine.mcol(S[this.C1 & 0xFF] & 0xFF ^ (S[this.C2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C0 >>> 24] << 24) ^ KW[r4][1];
        r2 = AESLightEngine.mcol(S[this.C2 & 0xFF] & 0xFF ^ (S[this.C3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C0 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C1 >>> 24] << 24) ^ KW[r4][2];
        r3 = AESLightEngine.mcol(S[this.C3 & 0xFF] & 0xFF ^ (S[this.C0 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[this.C1 >> 16 & 0xFF] & 0xFF) << 16 ^ S[this.C2 >>> 24] << 24) ^ KW[r4++][3];
        this.C0 = S[r0 & 0xFF] & 0xFF ^ (S[r1 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r2 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r3 >>> 24] << 24 ^ KW[r4][0];
        this.C1 = S[r1 & 0xFF] & 0xFF ^ (S[r2 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r3 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r0 >>> 24] << 24 ^ KW[r4][1];
        this.C2 = S[r2 & 0xFF] & 0xFF ^ (S[r3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r0 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r1 >>> 24] << 24 ^ KW[r4][2];
        this.C3 = S[r3 & 0xFF] & 0xFF ^ (S[r0 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[r1 >> 16 & 0xFF] & 0xFF) << 16 ^ S[r2 >>> 24] << 24 ^ KW[r4][3];
    }

    private void decryptBlock(int[][] KW) {
        int r3;
        int r2;
        int r1;
        int r0;
        this.C0 ^= KW[this.ROUNDS][0];
        this.C1 ^= KW[this.ROUNDS][1];
        this.C2 ^= KW[this.ROUNDS][2];
        this.C3 ^= KW[this.ROUNDS][3];
        int r4 = this.ROUNDS - 1;
        while (r4 > 1) {
            r0 = AESLightEngine.inv_mcol(Si[this.C0 & 0xFF] & 0xFF ^ (Si[this.C3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C1 >>> 24] << 24) ^ KW[r4][0];
            r1 = AESLightEngine.inv_mcol(Si[this.C1 & 0xFF] & 0xFF ^ (Si[this.C0 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C2 >>> 24] << 24) ^ KW[r4][1];
            r2 = AESLightEngine.inv_mcol(Si[this.C2 & 0xFF] & 0xFF ^ (Si[this.C1 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C0 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C3 >>> 24] << 24) ^ KW[r4][2];
            r3 = AESLightEngine.inv_mcol(Si[this.C3 & 0xFF] & 0xFF ^ (Si[this.C2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C1 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C0 >>> 24] << 24) ^ KW[r4--][3];
            this.C0 = AESLightEngine.inv_mcol(Si[r0 & 0xFF] & 0xFF ^ (Si[r3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[r2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[r1 >>> 24] << 24) ^ KW[r4][0];
            this.C1 = AESLightEngine.inv_mcol(Si[r1 & 0xFF] & 0xFF ^ (Si[r0 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[r3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[r2 >>> 24] << 24) ^ KW[r4][1];
            this.C2 = AESLightEngine.inv_mcol(Si[r2 & 0xFF] & 0xFF ^ (Si[r1 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[r0 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[r3 >>> 24] << 24) ^ KW[r4][2];
            this.C3 = AESLightEngine.inv_mcol(Si[r3 & 0xFF] & 0xFF ^ (Si[r2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[r1 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[r0 >>> 24] << 24) ^ KW[r4--][3];
        }
        r0 = AESLightEngine.inv_mcol(Si[this.C0 & 0xFF] & 0xFF ^ (Si[this.C3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C1 >>> 24] << 24) ^ KW[r4][0];
        r1 = AESLightEngine.inv_mcol(Si[this.C1 & 0xFF] & 0xFF ^ (Si[this.C0 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C2 >>> 24] << 24) ^ KW[r4][1];
        r2 = AESLightEngine.inv_mcol(Si[this.C2 & 0xFF] & 0xFF ^ (Si[this.C1 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C0 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C3 >>> 24] << 24) ^ KW[r4][2];
        r3 = AESLightEngine.inv_mcol(Si[this.C3 & 0xFF] & 0xFF ^ (Si[this.C2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[this.C1 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[this.C0 >>> 24] << 24) ^ KW[r4][3];
        this.C0 = Si[r0 & 0xFF] & 0xFF ^ (Si[r3 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[r2 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[r1 >>> 24] << 24 ^ KW[0][0];
        this.C1 = Si[r1 & 0xFF] & 0xFF ^ (Si[r0 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[r3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[r2 >>> 24] << 24 ^ KW[0][1];
        this.C2 = Si[r2 & 0xFF] & 0xFF ^ (Si[r1 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[r0 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[r3 >>> 24] << 24 ^ KW[0][2];
        this.C3 = Si[r3 & 0xFF] & 0xFF ^ (Si[r2 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[r1 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[r0 >>> 24] << 24 ^ KW[0][3];
    }
}

