/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x2 = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y2 = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x2);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y2, dsaParams), new DSAPrivateKeyParameters(x2, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q2, SecureRandom random) {
        return BigIntegers.createRandomInRange(ONE, q2.subtract(ONE), random);
    }

    private static BigInteger calculatePublicKey(BigInteger p2, BigInteger g2, BigInteger x2) {
        return g2.modPow(x2, p2);
    }
}

