/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponseData;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.SingleResponse;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.cert.ocsp.RespID;
import com.timevale.tgtext.bouncycastle.cert.ocsp.SingleResp;
import com.timevale.tgtext.bouncycastle.cert.ocsp.a;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class BasicOCSPResp {
    private BasicOCSPResponse resp;
    private ResponseData data;
    private Extensions extensions;

    public BasicOCSPResp(BasicOCSPResponse resp) {
        this.resp = resp;
        this.data = resp.getTbsResponseData();
        this.extensions = Extensions.getInstance(resp.getTbsResponseData().getResponseExtensions());
    }

    public byte[] getTBSResponseData() {
        try {
            return this.resp.getTbsResponseData().getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return a.a(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s2 = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s2.size()];
        for (int i2 = 0; i2 != rs.length; ++i2) {
            rs[i2] = new SingleResp(SingleResponse.getInstance(s2.getObjectAt(i2)));
        }
        return rs;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return a.c(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return a.a(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return a.b(this.extensions);
    }

    public ASN1ObjectIdentifier getSignatureAlgOID() {
        return this.resp.getSignatureAlgorithm().getAlgorithm();
    }

    public byte[] getSignature() {
        return this.resp.getSignature().getBytes();
    }

    public X509CertificateHolder[] getCerts() {
        if (this.resp.getCerts() != null) {
            ASN1Sequence s2 = this.resp.getCerts();
            if (s2 != null) {
                X509CertificateHolder[] certs = new X509CertificateHolder[s2.size()];
                for (int i2 = 0; i2 != certs.length; ++i2) {
                    certs[i2] = new X509CertificateHolder(Certificate.getInstance(s2.getObjectAt(i2)));
                }
                return certs;
            }
            return a.a;
        }
        return a.a;
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws OCSPException {
        try {
            ContentVerifier verifier = verifierProvider.get(this.resp.getSignatureAlgorithm());
            OutputStream vOut = verifier.getOutputStream();
            vOut.write(this.resp.getTbsResponseData().getEncoded("DER"));
            vOut.close();
            return verifier.verify(this.getSignature());
        }
        catch (Exception e2) {
            throw new OCSPException("exception processing sig: " + e2, e2);
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof BasicOCSPResp)) {
            return false;
        }
        BasicOCSPResp r2 = (BasicOCSPResp)o2;
        return this.resp.equals(r2.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

