/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.timevale.tgtext.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ECDomainParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.Certificate;
import com.timevale.tgtext.bouncycastle.crypto.tls.CertificateRequest;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsAgreementCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsKeyExchange;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.j;
import com.timevale.tgtext.bouncycastle.crypto.tls.o;
import com.timevale.tgtext.bouncycastle.crypto.tls.q;
import com.timevale.tgtext.bouncycastle.crypto.util.PublicKeyFactory;
import com.timevale.tgtext.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

class i
implements TlsKeyExchange {
    protected TlsClientContext a;
    protected int b;
    protected q c;
    protected AsymmetricKeyParameter d;
    protected ECPublicKeyParameters e;
    protected TlsAgreementCredentials f;
    protected ECPrivateKeyParameters g = null;

    i(TlsClientContext context, int keyExchange) {
        switch (keyExchange) {
            case 19: {
                this.c = new o();
                break;
            }
            case 17: {
                this.c = new j();
                break;
            }
            case 16: 
            case 18: {
                this.c = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.a = context;
        this.b = keyExchange;
    }

    @Override
    public void skipServerCertificate() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        com.timevale.tgtext.bouncycastle.asn1.x509.Certificate x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.d = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43);
        }
        if (this.c == null) {
            try {
                this.e = this.b((ECPublicKeyParameters)this.d);
            }
            catch (ClassCastException classCastException) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509Cert, 8);
            return;
        }
        if (!this.c.b(this.d)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(x509Cert, 128);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        block3: for (int i2 = 0; i2 < types.length; ++i2) {
            switch (types[i2]) {
                case 1: 
                case 2: 
                case 64: 
                case 65: 
                case 66: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    @Override
    public void skipClientCredentials() throws IOException {
        this.f = null;
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (clientCredentials instanceof TlsAgreementCredentials) {
            this.f = (TlsAgreementCredentials)clientCredentials;
            return;
        }
        if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream os) throws IOException {
        if (this.f == null) {
            this.a(this.e.getParameters(), os);
        }
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        if (this.f != null) {
            return this.f.generateAgreement(this.e);
        }
        return this.a(this.e, this.g);
    }

    protected boolean a(ECDomainParameters a2, ECDomainParameters b2) {
        return a2.getCurve().equals(b2.getCurve()) && a2.getG().equals(b2.getG()) && a2.getN().equals(b2.getN()) && a2.getH().equals(b2.getH());
    }

    protected byte[] a(ECPublicKeyParameters keyParameters) throws IOException {
        return keyParameters.getQ().getEncoded();
    }

    protected AsymmetricCipherKeyPair a(ECDomainParameters ecParams) {
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keyGenerationParameters = new ECKeyGenerationParameters(ecParams, this.a.getSecureRandom());
        keyPairGenerator.init(keyGenerationParameters);
        return keyPairGenerator.generateKeyPair();
    }

    protected void a(ECDomainParameters ecParams, OutputStream os) throws IOException {
        AsymmetricCipherKeyPair ecAgreeClientKeyPair = this.a(ecParams);
        this.g = (ECPrivateKeyParameters)ecAgreeClientKeyPair.getPrivate();
        byte[] keData = this.a((ECPublicKeyParameters)ecAgreeClientKeyPair.getPublic());
        TlsUtils.writeOpaque8(keData, os);
    }

    protected byte[] a(ECPublicKeyParameters publicKey, ECPrivateKeyParameters privateKey) {
        ECDHBasicAgreement basicAgreement = new ECDHBasicAgreement();
        basicAgreement.init(privateKey);
        BigInteger agreement = basicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(agreement);
    }

    protected ECPublicKeyParameters b(ECPublicKeyParameters key) throws IOException {
        return key;
    }
}

