/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope.sm2;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.algorithm.util.BigFileCipherUtil;
import cfca.sadk.lib.crypto.jni.JNISymAlg;
import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.StreamUtil;
import java.io.File;
import java.io.IOException;

public class SM2EncryptedInputStream
extends ASN1Primitive {
    private File file;
    private byte[] key;
    private Mechanism contentEncryptionAlg;
    private long length;
    private boolean useJNIFlag = false;

    public SM2EncryptedInputStream() {
    }

    public static SM2EncryptedInputStream getInstance(Object obj) {
        if (obj != null && obj instanceof SM2EncryptedInputStream) {
            return (SM2EncryptedInputStream)obj;
        }
        return null;
    }

    public SM2EncryptedInputStream(boolean useJNIFlag, File file, byte[] key, Mechanism contentEncryptionAlg) throws PKIException {
        this.useJNIFlag = useJNIFlag;
        this.file = file;
        this.key = key;
        this.contentEncryptionAlg = contentEncryptionAlg;
        long srcLength = file.length();
        if (srcLength == 0L) {
            throw new PKIException("source file is empty!");
        }
        long padd = srcLength & 0xFL;
        this.length = srcLength + 16L - padd;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isConstructed() {
        return false;
    }

    public int encodedLength() throws IOException {
        return 1 + StreamUtil.calculateBodyLength((int)this.length) + (int)this.length;
    }

    public void encode(ASN1OutputStream out) {
        try {
            out.write(4);
            out.writeLength((int)this.length);
            this.cryptoUtil(this.key, this.contentEncryptionAlg, out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean asn1Equals(ASN1Primitive o) {
        return false;
    }

    private void cryptoUtil(byte[] key, Mechanism algName, ASN1OutputStream out) throws Exception {
        SM4Engine cipher = null;
        if (algName.getMechanismType().indexOf("SM4") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            if (this.useJNIFlag) {
                BigFileCipherUtil.bigFileEncrypt_JNI(JNISymAlg.NID_ChinaSM4_CBC, key, param.getIv(), this.file, out);
            } else {
                cipher = new SM4Engine();
                BigFileCipherUtil.bigFileBlockEncrypt(key, cipher, param, this.file, out);
            }
        } else if (algName.getMechanismType().indexOf("SM4") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            cipher = new SM4Engine();
            BigFileCipherUtil.bigFileBlockEncrypt(key, cipher, null, this.file, out);
        } else {
            throw new Exception("can not support this algorithm to encrypt:" + algName.getMechanismType());
        }
    }
}

