/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.jcajce.signature;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.jcajce.signature.AlgorithmParameterImpl;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public class RSASignatureImpl
extends SignatureSpi {
    protected ASN1ObjectIdentifier OID;
    protected MessageDigest md;
    protected boolean mdReset;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected byte[] digestData;
    protected String signatureAlg;
    protected Signature sig;

    public RSASignatureImpl(String digestAlgorithm, ASN1ObjectIdentifier OID) {
        this.OID = OID;
        try {
            this.md = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e.getMessage());
        }
        this.mdReset = true;
    }

    protected void engineInitVerify(PublicKey paramPublicKey) throws InvalidKeyException {
        this.publicKey = paramPublicKey;
    }

    protected void engineInitSign(PrivateKey paramPrivateKey) throws InvalidKeyException {
        this.privateKey = paramPrivateKey;
    }

    protected void engineUpdate(byte paramByte) throws SignatureException {
    }

    protected void engineUpdate(byte[] input, int offset, int len) throws SignatureException {
        this.md.update(input, offset, len);
        this.digestData = this.md.digest();
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] signedData = null;
        try {
            AlgorithmIdentifier algId = new AlgorithmIdentifier(this.OID, DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algId, this.digestData);
            byte[] derDigestData = dInfo.getEncoded("DER");
            signedData = RSAPackageUtil.encrypt(derDigestData, this.privateKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signedData;
    }

    protected boolean engineVerify(byte[] paramArrayOfByte) throws SignatureException {
        try {
            AlgorithmIdentifier algId = new AlgorithmIdentifier(this.OID, DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algId, this.digestData);
            byte[] derDigestData = dInfo.getEncoded("DER");
            byte[] sig = RSAPackageUtil.decrypt(paramArrayOfByte, this.publicKey);
            return RSAPackageUtil.isRSAHashEqual(sig, derDigestData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void engineSetParameter(String paramString, Object paramObject) throws InvalidParameterException {
    }

    protected Object engineGetParameter(String paramString) throws InvalidParameterException {
        return null;
    }

    public static class MD5withRSAinPKCS7Wrapping
    extends MD5withRSA {
        protected AlgorithmParameterImpl algParamImpl;
        protected boolean hasSourceData;
        protected byte[] sourceData;
        protected X509Cert x509Cert;
        protected boolean isDERCoding;
        protected static Session session = null;

        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.algParamImpl = (AlgorithmParameterImpl)params;
            Boolean tmpHasSourceData = (Boolean)this.algParamImpl.algParamImpl[0];
            this.hasSourceData = tmpHasSourceData;
            this.x509Cert = (X509Cert)this.algParamImpl.algParamImpl[1];
            Boolean tmpisDERCoding = (Boolean)this.algParamImpl.algParamImpl[2];
            this.isDERCoding = tmpisDERCoding;
        }

        protected void engineUpdate(byte[] input, int offset, int len) throws SignatureException {
            this.sourceData = (byte[])input.clone();
            super.engineUpdate(input, offset, len);
            if (this.isDERCoding) {
                try {
                    AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, DERNull.INSTANCE);
                    DigestInfo dInfo = new DigestInfo(algId, this.digestData);
                    this.digestData = dInfo.getEncoded("DER");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        protected byte[] engineSign() throws SignatureException {
            byte[] p7SignedData = null;
            try {
                byte[] signedData = RSAPackageUtil.encrypt(this.digestData, this.privateKey);
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                X509Cert[] certs = new X509Cert[]{this.x509Cert};
                Mechanism mechanism = Mechanisms.M_MD5_RSA;
                p7SignedData = p7.packageSignedData(this.hasSourceData, null, this.sourceData, signedData, mechanism, certs);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return p7SignedData;
        }

        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                p7.loadDERData(sigBytes);
                if (this.hasSourceData) {
                    return p7.verifyP7SignedDataAttach();
                }
                return p7.verifyP7SignedData(this.sourceData);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
        }

        static {
            try {
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class SHA512withRSAinPKCS7Wrapping
    extends SHA512withRSA {
        protected AlgorithmParameterImpl algParamImpl;
        protected boolean hasSourceData;
        protected byte[] sourceData;
        protected X509Cert x509Cert;
        protected boolean isDERCoding;
        protected static Session session = null;

        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.algParamImpl = (AlgorithmParameterImpl)params;
            Boolean tmpHasSourceData = (Boolean)this.algParamImpl.algParamImpl[0];
            this.hasSourceData = tmpHasSourceData;
            this.x509Cert = (X509Cert)this.algParamImpl.algParamImpl[1];
            Boolean tmpisDERCoding = (Boolean)this.algParamImpl.algParamImpl[2];
            this.isDERCoding = tmpisDERCoding;
        }

        protected void engineUpdate(byte[] input, int offset, int len) throws SignatureException {
            this.sourceData = (byte[])input.clone();
            super.engineUpdate(input, offset, len);
            if (this.isDERCoding) {
                try {
                    AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, DERNull.INSTANCE);
                    DigestInfo dInfo = new DigestInfo(algId, this.digestData);
                    this.digestData = dInfo.getEncoded("DER");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        protected byte[] engineSign() throws SignatureException {
            byte[] p7SignedData = null;
            try {
                byte[] signedData = RSAPackageUtil.encrypt(this.digestData, this.privateKey);
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                X509Cert[] certs = new X509Cert[]{this.x509Cert};
                Mechanism mechanism = Mechanisms.M_SHA512_RSA;
                p7SignedData = p7.packageSignedData(this.hasSourceData, null, this.sourceData, signedData, mechanism, certs);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return p7SignedData;
        }

        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                p7.loadDERData(sigBytes);
                if (this.hasSourceData) {
                    return p7.verifyP7SignedDataAttach();
                }
                return p7.verifyP7SignedData(this.sourceData);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
        }

        static {
            try {
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class SHA256withRSAinPKCS7Wrapping
    extends SHA256withRSA {
        protected AlgorithmParameterImpl algParamImpl;
        protected boolean hasSourceData;
        protected byte[] sourceData;
        protected X509Cert x509Cert;
        protected boolean isDERCoding;
        protected static Session session = null;

        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.algParamImpl = (AlgorithmParameterImpl)params;
            Boolean tmpHasSourceData = (Boolean)this.algParamImpl.algParamImpl[0];
            this.hasSourceData = tmpHasSourceData;
            this.x509Cert = (X509Cert)this.algParamImpl.algParamImpl[1];
            Boolean tmpisDERCoding = (Boolean)this.algParamImpl.algParamImpl[2];
            this.isDERCoding = tmpisDERCoding;
        }

        protected void engineUpdate(byte[] input, int offset, int len) throws SignatureException {
            this.sourceData = (byte[])input.clone();
            super.engineUpdate(input, offset, len);
            if (this.isDERCoding) {
                try {
                    AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, DERNull.INSTANCE);
                    DigestInfo dInfo = new DigestInfo(algId, this.digestData);
                    this.digestData = dInfo.getEncoded("DER");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        protected byte[] engineSign() throws SignatureException {
            byte[] p7SignedData = null;
            try {
                byte[] signedData = RSAPackageUtil.encrypt(this.digestData, this.privateKey);
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                X509Cert[] certs = new X509Cert[]{this.x509Cert};
                Mechanism mechanism = Mechanisms.M_SHA256_RSA;
                p7SignedData = p7.packageSignedData(this.hasSourceData, null, this.sourceData, signedData, mechanism, certs);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return p7SignedData;
        }

        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                p7.loadDERData(sigBytes);
                if (this.hasSourceData) {
                    return p7.verifyP7SignedDataAttach();
                }
                return p7.verifyP7SignedData(this.sourceData);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
        }

        static {
            try {
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class SHA1withRSAinPKCS7Wrapping
    extends SHA1withRSA {
        protected AlgorithmParameterImpl algParamImpl;
        protected boolean hasSourceData;
        protected byte[] sourceData;
        protected X509Cert x509Cert;
        protected boolean isDERCoding;
        protected static Session session = null;

        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.algParamImpl = (AlgorithmParameterImpl)params;
            Boolean tmpHasSourceData = (Boolean)this.algParamImpl.algParamImpl[0];
            this.hasSourceData = tmpHasSourceData;
            this.x509Cert = (X509Cert)this.algParamImpl.algParamImpl[1];
            Boolean tmpisDERCoding = (Boolean)this.algParamImpl.algParamImpl[2];
            this.isDERCoding = tmpisDERCoding;
        }

        protected void engineUpdate(byte[] input, int offset, int len) throws SignatureException {
            this.sourceData = (byte[])input.clone();
            super.engineUpdate(input, offset, len);
            if (this.isDERCoding) {
                try {
                    AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, DERNull.INSTANCE);
                    DigestInfo dInfo = new DigestInfo(algId, this.digestData);
                    this.digestData = dInfo.getEncoded("DER");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        protected byte[] engineSign() throws SignatureException {
            byte[] p7SignedData = null;
            try {
                byte[] signedData = RSAPackageUtil.encrypt(this.digestData, this.privateKey);
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                X509Cert[] certs = new X509Cert[]{this.x509Cert};
                Mechanism mechanism = Mechanisms.M_SHA1_RSA;
                p7SignedData = p7.packageSignedData(this.hasSourceData, null, this.sourceData, signedData, mechanism, certs);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return p7SignedData;
        }

        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                p7.loadDERData(sigBytes);
                if (this.hasSourceData) {
                    return p7.verifyP7SignedDataAttach();
                }
                return p7.verifyP7SignedData(this.sourceData);
            }
            catch (PKIException e) {
                throw new SignatureException(e.getMessage());
            }
        }

        static {
            try {
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                session = JCrypto.getInstance().openSession("JSOFT_LIB");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class MD5withRSA
    extends RSASignatureImpl {
        public MD5withRSA() {
            super("MD5", PKCSObjectIdentifiers.md5);
        }
    }

    public static class SHA512withRSA
    extends RSASignatureImpl {
        public SHA512withRSA() {
            super("SHA-512", PKCSObjectIdentifiers.sha512);
        }
    }

    public static class SHA256withRSA
    extends RSASignatureImpl {
        public SHA256withRSA() {
            super("SHA-256", PKCSObjectIdentifiers.sha256);
        }
    }

    public static class SHA1withRSA
    extends RSASignatureImpl {
        public SHA1withRSA() {
            super("SHA1", PKCSObjectIdentifiers.sha1);
        }
    }
}

