/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import java.util.HashMap;

final class CRLSignType {
    final int signType_rsa_md5 = 10;
    final int signType_rsa_sha1 = 11;
    final int signType_rsa_sha256 = 12;
    final int signType_rsa_sha512 = 13;
    final int signType_sm2_sm3 = 20;
    final HashMap values = new HashMap();

    CRLSignType() {
        this.values.put(PKCSObjectIdentifiers.md5WithRSAEncryption.getId(), Integer.toString(10));
        this.values.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), Integer.toString(11));
        this.values.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), Integer.toString(12));
        this.values.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), Integer.toString(13));
        this.values.put(GMObjectIdentifiers.SM3WithSM2Encryption.getId(), Integer.toString(20));
    }

    final String getSignType(String oid) throws PKIException {
        String mechanismType = null;
        String value = (String)this.values.get(oid);
        if (value == null) {
            throw new PKIException("CrlFile verify failure when invalid signatureAlgorithm --> " + oid);
        }
        switch (Integer.parseInt(value)) {
            case 10: {
                mechanismType = "md5WithRSAEncryption";
                break;
            }
            case 11: {
                mechanismType = "sha1WithRSAEncryption";
                break;
            }
            case 12: {
                mechanismType = "sha256WithRSAEncryption";
                break;
            }
            case 13: {
                mechanismType = "sha512WithRSAEncryption";
                break;
            }
            case 20: {
                mechanismType = "sm3WithSM2Encryption";
                break;
            }
            default: {
                throw new PKIException("CrlFile verify failure when invalid signatureAlgorithm --> " + oid);
            }
        }
        return mechanismType;
    }

    final Digest getDigestEngine(String oid) throws PKIException {
        ExtendedDigest engine = null;
        String value = (String)this.values.get(oid);
        if (value == null) {
            throw new PKIException("CrlFile verify failure when invalid signatureAlgorithm --> " + oid);
        }
        switch (Integer.parseInt(value)) {
            case 10: {
                engine = new MD5Digest();
                break;
            }
            case 11: {
                engine = new SHA1Digest();
                break;
            }
            case 12: {
                engine = new SHA256Digest();
                break;
            }
            case 13: {
                engine = new SHA512Digest();
                break;
            }
            case 20: {
                engine = new SM3Digest();
                break;
            }
            default: {
                throw new PKIException("CrlFile verify failure when invalid signatureAlgorithm --> " + oid);
            }
        }
        return engine;
    }
}

