/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mozilla;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.mozilla.PublicKeyAndChallenge;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;

public class SignedPublicKeyAndChallenge
extends ASN1Object {
    private ASN1Sequence spkacSeq;
    private PublicKeyAndChallenge pkac;
    private AlgorithmIdentifier signatureAlgorithm;
    private DERBitString signature;

    private static ASN1Sequence toDERSequence(byte[] bytes) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            return (ASN1Sequence)aIn.readObject();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public SignedPublicKeyAndChallenge(byte[] bytes) {
        this.spkacSeq = SignedPublicKeyAndChallenge.toDERSequence(bytes);
        this.pkac = PublicKeyAndChallenge.getInstance(this.spkacSeq.getObjectAt(0));
        this.signatureAlgorithm = AlgorithmIdentifier.getInstance(this.spkacSeq.getObjectAt(1));
        this.signature = (DERBitString)this.spkacSeq.getObjectAt(2);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.spkacSeq;
    }

    public PublicKeyAndChallenge getPublicKeyAndChallenge() {
        return this.pkac;
    }

    public boolean verify() throws NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        return this.verify(null);
    }

    public boolean verify(String provider) throws NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        Signature sig = provider == null ? Signature.getInstance(this.signatureAlgorithm.getAlgorithm().getId()) : Signature.getInstance(this.signatureAlgorithm.getAlgorithm().getId(), provider);
        PublicKey pubKey = this.getPublicKey(provider);
        sig.initVerify(pubKey);
        try {
            DERBitString pkBytes = new DERBitString(this.pkac);
            sig.update(pkBytes.getBytes());
            return sig.verify(this.signature.getBytes());
        }
        catch (Exception exception) {
            throw new InvalidKeyException("error encoding public key");
        }
    }

    public PublicKey getPublicKey(String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        SubjectPublicKeyInfo subjectPKInfo = this.pkac.getSubjectPublicKeyInfo();
        try {
            DERBitString bStr = new DERBitString(subjectPKInfo);
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(bStr.getBytes());
            AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithm();
            KeyFactory factory = KeyFactory.getInstance(keyAlg.getAlgorithm().getId(), provider);
            return factory.generatePublic(xspec);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("error encoding public key");
        }
    }
}

