/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.pkcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class DHParameter
extends ASN1Object {
    ASN1Integer p;
    ASN1Integer g;
    ASN1Integer l;

    public DHParameter(BigInteger p2, BigInteger g2, int l2) {
        this.p = new ASN1Integer(p2);
        this.g = new ASN1Integer(g2);
        if (l2 != 0) {
            this.l = new ASN1Integer(l2);
            return;
        }
        this.l = null;
    }

    public static DHParameter getInstance(Object obj) {
        if (obj instanceof DHParameter) {
            return (DHParameter)obj;
        }
        if (obj != null) {
            return new DHParameter(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private DHParameter(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        this.p = ASN1Integer.getInstance(e2.nextElement());
        this.g = ASN1Integer.getInstance(e2.nextElement());
        if (e2.hasMoreElements()) {
            this.l = (ASN1Integer)e2.nextElement();
            return;
        }
        this.l = null;
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public BigInteger getL() {
        if (this.l == null) {
            return null;
        }
        return this.l.getPositiveValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.p);
        v2.add(this.g);
        if (this.getL() != null) {
            v2.add(this.l);
        }
        return new DERSequence(v2);
    }
}

