/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x9;

import com.timevale.tgtext.bouncycastle.math.ec.ECCurve;
import com.timevale.tgtext.bouncycastle.math.ec.ECFieldElement;
import java.math.BigInteger;

public class X9IntegerConverter {
    public int getByteLength(ECCurve c2) {
        return (c2.getFieldSize() + 7) / 8;
    }

    public int getByteLength(ECFieldElement fe2) {
        return (fe2.getFieldSize() + 7) / 8;
    }

    public byte[] integerToBytes(BigInteger s2, int qLength) {
        byte[] bytes = s2.toByteArray();
        if (qLength < bytes.length) {
            byte[] tmp = new byte[qLength];
            System.arraycopy(bytes, bytes.length - qLength, tmp, 0, qLength);
            return tmp;
        }
        if (qLength > bytes.length) {
            byte[] tmp = new byte[qLength];
            System.arraycopy(bytes, 0, tmp, qLength - bytes.length, bytes.length);
            return tmp;
        }
        return bytes;
    }
}

