/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.HashEncoderUtil;
import cfca.sadk.asn1.DERHeader;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.global.FileAndBufferConfig;
import cfca.sadk.util.KeyUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public class HardLib
implements Session {
    final String signByHash_ALG;
    private String providerName;
    private Provider provider;
    final boolean sm2SigningASN1Format;
    final boolean sm2EncryptASN1Format;
    final String transformation_cbc_pkcs7_des3 = "DESede/CBC/PKCS7Padding";
    final String transformation_cbc_pkcs7_sm4 = "SM4/CBC/PKCS7Padding";
    final int buffsize = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardLib(String providerPath) throws PKIException {
        if (providerPath == null || providerPath.trim().equals("")) {
            providerPath = "com.sansec.jce.provider.SwxaProvider";
        }
        try {
            this.provider = (Provider)Class.forName(providerPath).newInstance();
            this.providerName = this.provider.getName();
        }
        catch (Exception e) {
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + this.providerName, e);
        }
        Mechanism mechanism = null;
        KeyPair keypair = null;
        try {
            mechanism = new Mechanism("SM2");
            keypair = this.generateKeyPair(mechanism, 256);
        }
        catch (Exception e) {
            // empty catch block
        }
        String signByHash = "SM2";
        try {
            Signature.getInstance("SimuSM2", this.provider);
            signByHash = "SimuSM2";
        }
        catch (Exception e) {
            signByHash = "SM2";
        }
        finally {
            this.signByHash_ALG = signByHash;
        }
        this.sm2SigningASN1Format = this.signingFormat(keypair);
        this.sm2EncryptASN1Format = this.encryptFormat(keypair);
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        PrivateKey privateKey = this.SM2HardPrivateKey(mechanism, priKey);
        String mType = mechanism.getMechanismType();
        byte[] signData = null;
        try {
            Signature signature = Signature.getInstance(mType, this.provider);
            signature.initSign(privateKey);
            signature.update(sourceData);
            signData = signature.sign();
            return this.signedOutFormat(mechanism, signData);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
        }
    }

    public byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        PrivateKey privateKey = this.SM2HardPrivateKey(mechanism, priKey);
        String mType = mechanism.getMechanismType();
        byte[] signData = null;
        InputStream sourceData = null;
        try {
            Signature signature = Signature.getInstance(mType, this.provider);
            signature.initSign(privateKey);
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            int i = 0;
            sourceData = new BufferedInputStream(sourceStream);
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            signData = signature.sign();
            byte[] byArray = this.signedOutFormat(mechanism, signData);
            return byArray;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
        }
        finally {
            if (sourceData != null) {
                try {
                    sourceData.close();
                }
                catch (Exception e) {
                    throw new PKIException("Signed failure", e);
                }
            }
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        PublicKey publicKey = this.SM2HardPublicKey(mechanism, pubKey);
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), this.provider);
            signature.initVerify(publicKey);
            byte[] signedData = this.signedInFormat(mechanism, signData);
            signature.update(sourceData);
            return signature.verify(signedData);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, ex);
        }
    }

    public boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        PublicKey publicKey = this.SM2HardPublicKey(mechanism, pubKey);
        InputStream sourceData = null;
        try {
            Signature signature = Signature.getInstance(mechanism.getMechanismType(), this.provider);
            signature.initVerify(publicKey);
            byte[] signedData = this.signedInFormat(mechanism, signData);
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            int i = 0;
            sourceData = new BufferedInputStream(sourceStream);
            while ((i = sourceData.read(buffer)) > 0) {
                signature.update(buffer, 0, i);
            }
            boolean bl = signature.verify(signedData);
            return bl;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, ex);
        }
        finally {
            if (sourceData != null) {
                try {
                    sourceData.close();
                }
                catch (Exception e) {
                    throw new PKIException("Verified failure", e);
                }
            }
        }
    }

    public byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        Key hard = key;
        boolean sm2Operation = false;
        if (Mechanisms.isSM2Type(mechanism)) {
            hard = this.SM2HardPublicKey(mechanism, (PublicKey)key);
            sm2Operation = true;
        }
        Cipher cipher = this.engine(mechanism, 1, hard);
        try {
            byte[] encryptedData = cipher.doFinal(sourceData);
            if (sm2Operation) {
                encryptedData = this.sm2EncryptOutFormat(encryptedData);
            }
            return encryptedData;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        Key hard = key;
        boolean sm2Operation = false;
        if (Mechanisms.isSM2Type(mechanism)) {
            sm2Operation = true;
            hard = this.SM2HardPrivateKey(mechanism, (PrivateKey)key);
        }
        Cipher cipher = this.engine(mechanism, 2, hard);
        try {
            byte[] encryptedData = encryptData;
            if (sm2Operation) {
                return this.SM2Decrypt(cipher, encryptData, hard);
            }
            return cipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    public KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        String mType = mechanism.getMechanismType();
        boolean isExport = true;
        int keyNum = 0;
        Object object = mechanism.getParam();
        if (object != null) {
            GenKeyAttribute attr = (GenKeyAttribute)object;
            isExport = attr.isExport;
            if (!isExport) {
                keyNum = attr.keyNum;
            }
        }
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(mType, this.provider);
            if (isExport) {
                keyPairGen.initialize(keyLength);
            } else {
                keyPairGen.initialize(keyNum << 16);
            }
            return keyPairGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new PKIException(PKIException.HARD_KEY_PAIR, PKIException.HARD_KEY_PAIR_DES, e);
        }
    }

    public byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] digest) throws PKIException {
        PrivateKey privateKey = this.SM2HardPrivateKey(mechanism, priKey);
        int cipherMode = 1;
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                Signature signature = Signature.getInstance(this.signByHash_ALG, this.provider);
                signature.initSign(privateKey);
                signature.update(digest);
                byte[] signData = signature.sign();
                return this.signedOutFormat(mechanism, signData);
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.provider);
            cipher.init(cipherMode, priKey);
            byte[] derDigest = HashEncoderUtil.derEncoder(mechanism.getMechanismType(), digest);
            return cipher.doFinal(derDigest);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCRYPT, PKIException.ENCRYPT_DES, e);
        }
    }

    public boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] digest, byte[] signData) throws PKIException {
        PublicKey publicKey = this.SM2HardPublicKey(mechanism, pubKey);
        int cipherMode = 2;
        try {
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                Signature signature = Signature.getInstance(this.signByHash_ALG, this.provider);
                signature.initVerify(publicKey);
                signature.update(digest);
                byte[] signedData = this.signedInFormat(mechanism, signData);
                return signature.verify(signedData);
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.provider);
            cipher.init(cipherMode, pubKey);
            byte[] extractHash = cipher.doFinal(signData);
            byte[] derDigest = HashEncoderUtil.derEncoder(mechanism, digest);
            return RSAPackageUtil.isRSAHashEqual(extractHash, derDigest);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.DECRYPT, PKIException.DECRYPT_DES, e);
        }
    }

    public void encrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws PKIException {
        if (this.isSM2Type(mechanism)) {
            int mLength;
            byte[] message;
            try {
                message = new byte[8192];
                mLength = in.read(message);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.ENCRYPT, "file read failure");
            }
            if (mLength > 4096) {
                throw new PKIException(PKIException.ENCRYPT, "file length limited with 4096");
            }
            byte[] encryptedData = this.encrypt(mechanism, key, message);
            try {
                out.write(encryptedData, 0, encryptedData.length);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.ENCRYPT, "file write failure");
            }
            return;
        }
        Cipher cipher = this.engine(mechanism, 1, key);
        byte[] buffer = new byte[16384];
        FilterOutputStream bufferOS = null;
        BufferedInputStream bufferIS = null;
        try {
            bufferOS = new BufferedOutputStream(new CipherOutputStream(out, cipher), 16384);
            bufferIS = new BufferedInputStream(in, 16384);
            int len = 0;
            while ((len = bufferIS.read(buffer)) > 0) {
                ((BufferedOutputStream)bufferOS).write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new PKIException("Encrypt failure", e);
        }
        catch (Exception e) {
            throw new PKIException("Encrypt failure", e);
        }
        finally {
            if (bufferOS != null) {
                try {
                    bufferOS.close();
                }
                catch (IOException e) {}
            }
            if (bufferIS != null) {
                try {
                    bufferIS.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void decrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws PKIException {
        if (this.isSM2Type(mechanism)) {
            int mLength;
            byte[] message;
            try {
                message = new byte[8192];
                mLength = in.read(message);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.DECRYPT, "file read failure");
            }
            if (mLength > 5120) {
                throw new PKIException(PKIException.DECRYPT, "file length limited with 4096");
            }
            byte[] decryptedData = this.decrypt(mechanism, key, message);
            try {
                out.write(decryptedData, 0, decryptedData.length);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.DECRYPT, "file write failure");
            }
            return;
        }
        Cipher cipher = this.engine(mechanism, 2, key);
        byte[] buffer = new byte[16384];
        BufferedOutputStream bufferOS = null;
        BufferedInputStream bufferIS = null;
        try {
            bufferOS = new BufferedOutputStream(out, 16384);
            bufferIS = new BufferedInputStream(new CipherInputStream(in, cipher), 16384);
            int len = 0;
            while ((len = bufferIS.read(buffer)) > 0) {
                bufferOS.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new PKIException("Decrypt failure", e);
        }
        catch (Exception e) {
            throw new PKIException("Decrypt failure", e);
        }
        finally {
            if (bufferOS != null) {
                try {
                    bufferOS.close();
                }
                catch (IOException e) {}
            }
            if (bufferIS != null) {
                try {
                    bufferIS.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Key generateKey(Mechanism keyType) throws PKIException {
        KeyGenerator keyGen;
        String type = keyType.getMechanismType();
        int len = 0;
        if (type.equals("RC4")) {
            len = 128;
        } else if (type.equals("DESede")) {
            len = 192;
        } else if (type.equals("SM4")) {
            len = 128;
        } else {
            throw new PKIException("do not support this key type:" + type);
        }
        try {
            keyGen = KeyGenerator.getInstance(type, this.provider);
            keyGen.init(len);
        }
        catch (Exception e) {
            throw new PKIException("KeyGenerator init failure", e);
        }
        return keyGen.generateKey();
    }

    public Key generateKey(Mechanism keyType, byte[] keyData) throws PKIException {
        return KeyUtil.generateKey(keyType, keyData);
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getProviderName() {
        return this.providerName;
    }

    private final boolean isSM2Type(Mechanism mechanism) {
        boolean convertFlag = true;
        convertFlag = mechanism == null || mechanism.getMechanismType() == null ? true : mechanism.getMechanismType().toUpperCase().indexOf("SM2") != -1;
        return convertFlag;
    }

    public final PublicKey SM2HardPublicKey(Mechanism mechanism, PublicKey pubKey) throws PKIException {
        if (pubKey != null && this.isSM2Type(mechanism) && pubKey instanceof ECPublicKey) {
            try {
                KeyFactory kf = KeyFactory.getInstance("SM2", this.provider);
                X509EncodedKeySpec x509spec = new X509EncodedKeySpec(pubKey.getEncoded());
                return kf.generatePublic(x509spec);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.COV_PUB_KEY, PKIException.COV_PUB_KEY_DES, ex);
            }
        }
        return pubKey;
    }

    public final PrivateKey SM2HardPrivateKey(Mechanism mechanism, PrivateKey privKey) throws PKIException {
        if (privKey != null && this.isSM2Type(mechanism) && privKey instanceof ECPrivateKey) {
            try {
                KeyFactory kf = KeyFactory.getInstance("SM2", this.provider);
                PKCS8EncodedKeySpec x509spec = new PKCS8EncodedKeySpec(privKey.getEncoded());
                return kf.generatePrivate(x509spec);
            }
            catch (Exception ex) {
                throw new PKIException(PKIException.COV_PRV_KEY, PKIException.COV_PRV_KEY_DES, ex);
            }
        }
        return privKey;
    }

    private final boolean signingFormat(KeyPair keypair) {
        boolean asnFormat = false;
        if (keypair != null) {
            try {
                Signature signature = Signature.getInstance("SM2", this.provider);
                signature.initSign(keypair.getPrivate());
                signature.update(new byte[32]);
                byte[] signData = signature.sign();
                asnFormat = signData != null && signData.length > 64;
            }
            catch (Exception e) {
                asnFormat = false;
            }
        }
        return asnFormat;
    }

    private final boolean encryptFormat(KeyPair keypair) {
        boolean asnFormat = false;
        if (keypair != null) {
            try {
                Cipher cipher = Cipher.getInstance("SM2", this.provider);
                cipher.init(1, keypair.getPublic());
                byte[] encrypedData = cipher.doFinal(new byte[32]);
                asnFormat = encrypedData.length > 128;
            }
            catch (Exception e) {
                asnFormat = false;
            }
        }
        return asnFormat;
    }

    private final byte[] signedOutFormat(Mechanism mechanism, byte[] signData) {
        if (signData != null && this.isSM2Type(mechanism) && signData.length != 64) {
            return new ASN1SM2Signature(signData).getRS();
        }
        return signData;
    }

    private byte[] signedInFormat(Mechanism mechanism, byte[] signData) {
        if (signData != null && this.isSM2Type(mechanism)) {
            try {
                if (this.sm2SigningASN1Format) {
                    if (signData.length == 64) {
                        return new ASN1SM2Signature(signData).getEncoded();
                    }
                } else if (signData.length != 64) {
                    return new ASN1SM2Signature(signData).getRS();
                }
            }
            catch (Exception e) {
                return signData;
            }
        }
        return signData;
    }

    private final byte[] sm2EncryptOutFormat(byte[] encryptedData) {
        return encryptedData;
    }

    private final byte[] SM2Decrypt(Cipher engine, byte[] encryptData, Key key) throws PKIException, Exception {
        if (encryptData == null || encryptData.length < 96) {
            throw new PKIException(PKIException.DECRYPT, "encryptData too shortage");
        }
        DERHeader der = null;
        try {
            der = new DERHeader(encryptData, 0);
        }
        catch (Exception e) {
            der = null;
        }
        if (der != null && (der.getTag() == 48 || der.getDerLength() == encryptData.length)) {
            return engine.doFinal(encryptData);
        }
        try {
            ASN1SM2Cipher asn = new ASN1SM2Cipher(encryptData, 4);
            return engine.doFinal(asn.getEncoded());
        }
        catch (Exception e) {
            engine.init(2, key);
            ASN1SM2Cipher asn = new ASN1SM2Cipher(encryptData, 16);
            return engine.doFinal(asn.getEncoded());
        }
    }

    private final Cipher engine(Mechanism mechanism, int opmode, Key key) throws PKIException {
        Cipher cipher;
        String mType = mechanism.getMechanismType();
        try {
            cipher = Cipher.getInstance(mType, this.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PKIException(PKIException.JHARDLIB + ": " + e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new PKIException(PKIException.JHARDLIB + ": " + e.getMessage(), e);
        }
        try {
            if (mType.indexOf("CBC") != -1) {
                CBCParam cbcParam = (CBCParam)mechanism.getParam();
                if (cbcParam == null) {
                    throw new IllegalArgumentException("mechanism missing param");
                }
                IvParameterSpec iv = new IvParameterSpec(cbcParam.getIv());
                cipher.init(opmode, key, iv);
            } else {
                cipher.init(opmode, key);
            }
        }
        catch (InvalidKeyException e) {
            throw new PKIException(PKIException.JHARDLIB + ": " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PKIException(PKIException.JHARDLIB + ": " + e.getMessage(), e);
        }
        return cipher;
    }
}

