/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;

public class GF2nPolynomial {
    private GF2nElement[] coeff;
    private int size;

    public GF2nPolynomial(int deg, GF2nElement elem) {
        this.size = deg;
        this.coeff = new GF2nElement[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.coeff[i2] = (GF2nElement)elem.clone();
        }
    }

    private GF2nPolynomial(int deg) {
        this.size = deg;
        this.coeff = new GF2nElement[this.size];
    }

    public GF2nPolynomial(GF2nPolynomial a2) {
        this.coeff = new GF2nElement[a2.size];
        this.size = a2.size;
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.coeff[i2] = (GF2nElement)a2.coeff[i2].clone();
        }
    }

    public GF2nPolynomial(GF2Polynomial polynomial, GF2nField B1) {
        this.size = B1.getDegree() + 1;
        this.coeff = new GF2nElement[this.size];
        if (B1 instanceof GF2nONBField) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                this.coeff[i2] = polynomial.testBit(i2) ? GF2nONBElement.ONE((GF2nONBField)B1) : GF2nONBElement.ZERO((GF2nONBField)B1);
            }
        } else if (B1 instanceof GF2nPolynomialField) {
            for (int i3 = 0; i3 < this.size; ++i3) {
                this.coeff[i3] = polynomial.testBit(i3) ? GF2nPolynomialElement.ONE((GF2nPolynomialField)B1) : GF2nPolynomialElement.ZERO((GF2nPolynomialField)B1);
            }
        } else {
            throw new IllegalArgumentException("PolynomialGF2n(Bitstring, GF2nField): B1 must be an instance of GF2nONBField or GF2nPolynomialField!");
        }
    }

    public final void assignZeroToElements() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.coeff[i2].assignZero();
        }
    }

    public final int size() {
        return this.size;
    }

    public final int getDegree() {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (this.coeff[i2].isZero()) continue;
            return i2;
        }
        return -1;
    }

    public final void enlarge(int k2) {
        if (k2 <= this.size) {
            return;
        }
        GF2nElement[] res = new GF2nElement[k2];
        System.arraycopy(this.coeff, 0, res, 0, this.size);
        GF2nField f2 = this.coeff[0].getField();
        if (this.coeff[0] instanceof GF2nPolynomialElement) {
            for (int i2 = this.size; i2 < k2; ++i2) {
                res[i2] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)f2);
            }
        } else if (this.coeff[0] instanceof GF2nONBElement) {
            for (int i3 = this.size; i3 < k2; ++i3) {
                res[i3] = GF2nONBElement.ZERO((GF2nONBField)f2);
            }
        }
        this.size = k2;
        this.coeff = res;
    }

    public final void shrink() {
        int i2;
        for (i2 = this.size - 1; this.coeff[i2].isZero() && i2 > 0; --i2) {
        }
        if (++i2 < this.size) {
            GF2nElement[] res = new GF2nElement[i2];
            System.arraycopy(this.coeff, 0, res, 0, i2);
            this.coeff = res;
            this.size = i2;
        }
    }

    public final void set(int index, GF2nElement elem) {
        if (!(elem instanceof GF2nPolynomialElement) && !(elem instanceof GF2nONBElement)) {
            throw new IllegalArgumentException("PolynomialGF2n.set f must be an instance of either GF2nPolynomialElement or GF2nONBElement!");
        }
        this.coeff[index] = (GF2nElement)elem.clone();
    }

    public final GF2nElement at(int index) {
        return this.coeff[index];
    }

    public final boolean isZero() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.coeff[i2] == null || this.coeff[i2].isZero()) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nPolynomial)) {
            return false;
        }
        GF2nPolynomial otherPol = (GF2nPolynomial)other;
        if (this.getDegree() != otherPol.getDegree()) {
            return false;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.coeff[i2].equals(otherPol.coeff[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getDegree() + this.coeff.hashCode();
    }

    public final GF2nPolynomial add(GF2nPolynomial b2) throws RuntimeException {
        GF2nPolynomial result;
        if (this.size() >= b2.size()) {
            int i2;
            result = new GF2nPolynomial(this.size());
            for (i2 = 0; i2 < b2.size(); ++i2) {
                result.coeff[i2] = (GF2nElement)this.coeff[i2].add(b2.coeff[i2]);
            }
            while (i2 < this.size()) {
                result.coeff[i2] = this.coeff[i2];
                ++i2;
            }
        } else {
            int i3;
            result = new GF2nPolynomial(b2.size());
            for (i3 = 0; i3 < this.size(); ++i3) {
                result.coeff[i3] = (GF2nElement)this.coeff[i3].add(b2.coeff[i3]);
            }
            while (i3 < b2.size()) {
                result.coeff[i3] = b2.coeff[i3];
                ++i3;
            }
        }
        return result;
    }

    public final GF2nPolynomial scalarMultiply(GF2nElement s2) throws RuntimeException {
        GF2nPolynomial result = new GF2nPolynomial(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            result.coeff[i2] = (GF2nElement)this.coeff[i2].multiply(s2);
        }
        return result;
    }

    public final GF2nPolynomial multiply(GF2nPolynomial b2) throws RuntimeException {
        int bDegree;
        int aDegree = this.size();
        if (aDegree != (bDegree = b2.size())) {
            throw new IllegalArgumentException("PolynomialGF2n.multiply: this and b must have the same size!");
        }
        GF2nPolynomial result = new GF2nPolynomial((aDegree << 1) - 1);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            for (int j2 = 0; j2 < b2.size(); ++j2) {
                result.coeff[i2 + j2] = result.coeff[i2 + j2] == null ? (GF2nElement)this.coeff[i2].multiply(b2.coeff[j2]) : (GF2nElement)result.coeff[i2 + j2].add(this.coeff[i2].multiply(b2.coeff[j2]));
            }
        }
        return result;
    }

    public final GF2nPolynomial multiplyAndReduce(GF2nPolynomial b2, GF2nPolynomial g2) throws RuntimeException, ArithmeticException {
        return this.multiply(b2).reduce(g2);
    }

    public final GF2nPolynomial reduce(GF2nPolynomial g2) throws RuntimeException, ArithmeticException {
        return this.remainder(g2);
    }

    public final void shiftThisLeft(int amount) {
        block3: {
            int i2;
            GF2nField f2;
            block4: {
                if (amount <= 0) break block3;
                int oldSize = this.size;
                f2 = this.coeff[0].getField();
                this.enlarge(this.size + amount);
                for (i2 = oldSize - 1; i2 >= 0; --i2) {
                    this.coeff[i2 + amount] = this.coeff[i2];
                }
                if (!(this.coeff[0] instanceof GF2nPolynomialElement)) break block4;
                for (i2 = amount - 1; i2 >= 0; --i2) {
                    this.coeff[i2] = GF2nPolynomialElement.ZERO((GF2nPolynomialField)f2);
                }
                break block3;
            }
            if (!(this.coeff[0] instanceof GF2nONBElement)) break block3;
            for (i2 = amount - 1; i2 >= 0; --i2) {
                this.coeff[i2] = GF2nONBElement.ZERO((GF2nONBField)f2);
            }
        }
    }

    public final GF2nPolynomial shiftLeft(int amount) {
        if (amount <= 0) {
            return new GF2nPolynomial(this);
        }
        GF2nPolynomial result = new GF2nPolynomial(this.size + amount, this.coeff[0]);
        result.assignZeroToElements();
        for (int i2 = 0; i2 < this.size; ++i2) {
            result.coeff[i2 + amount] = this.coeff[i2];
        }
        return result;
    }

    public final GF2nPolynomial[] divide(GF2nPolynomial b2) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] result = new GF2nPolynomial[2];
        GF2nPolynomial a2 = new GF2nPolynomial(this);
        a2.shrink();
        int bDegree = b2.getDegree();
        GF2nElement inv = (GF2nElement)b2.coeff[bDegree].invert();
        if (a2.getDegree() < bDegree) {
            result[0] = new GF2nPolynomial(this);
            result[0].assignZeroToElements();
            result[0].shrink();
            result[1] = new GF2nPolynomial(this);
            result[1].shrink();
            return result;
        }
        result[0] = new GF2nPolynomial(this);
        result[0].assignZeroToElements();
        int i2 = a2.getDegree() - bDegree;
        while (i2 >= 0) {
            GF2nElement factor = (GF2nElement)a2.coeff[a2.getDegree()].multiply(inv);
            GF2nPolynomial shift = b2.scalarMultiply(factor);
            shift.shiftThisLeft(i2);
            a2 = a2.add(shift);
            a2.shrink();
            result[0].coeff[i2] = (GF2nElement)factor.clone();
            i2 = a2.getDegree() - bDegree;
        }
        result[1] = a2;
        result[0].shrink();
        return result;
    }

    public final GF2nPolynomial remainder(GF2nPolynomial b2) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] result = this.divide(b2);
        return result[1];
    }

    public final GF2nPolynomial quotient(GF2nPolynomial b2) throws RuntimeException, ArithmeticException {
        GF2nPolynomial[] result = this.divide(b2);
        return result[0];
    }

    public final GF2nPolynomial gcd(GF2nPolynomial g2) throws RuntimeException, ArithmeticException {
        GF2nPolynomial a2 = new GF2nPolynomial(this);
        GF2nPolynomial b2 = new GF2nPolynomial(g2);
        a2.shrink();
        b2.shrink();
        while (!b2.isZero()) {
            GF2nPolynomial c2 = a2.remainder(b2);
            a2 = b2;
            b2 = c2;
        }
        GF2nElement alpha = a2.coeff[a2.getDegree()];
        GF2nPolynomial result = a2.scalarMultiply((GF2nElement)alpha.invert());
        return result;
    }
}

