/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.g3.sdk.yop.error.YopError;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonJsonMarshaller;
import com.yeepay.g3.sdk.yop.unmarshaller.KeepAsRawStringDeserializer;
import com.yeepay.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import com.yeepay.shade.com.fasterxml.jackson.annotation.JsonProperty;
import com.yeepay.shade.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yeepay.shade.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import com.yeepay.shade.org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import com.yeepay.shade.org.apache.commons.lang3.builder.ToStringStyle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@JacksonXmlRootElement(localName="response")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="response")
public class YopResponse {
    private transient Map<String, String> headers;
    @XmlElement
    private String state;
    private String requestId;
    @JsonIgnore
    private Object result;
    @XmlElement
    private Long ts;
    @XmlElement
    private String sign;
    @XmlElement
    private YopError error;
    @JsonProperty(value="result")
    @JsonDeserialize(using=KeepAsRawStringDeserializer.class)
    private String stringResult;
    @Deprecated
    private boolean validSign = true;

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Long getTs() {
        return this.ts;
    }

    public void setTs(Long ts) {
        this.ts = ts;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public YopError getError() {
        return this.error;
    }

    public void setError(YopError error) {
        this.error = error;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public YopResponse addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = Maps.newHashMap();
        }
        this.headers.put(name, value);
        return this;
    }

    public String getStringResult() {
        return this.stringResult;
    }

    public void setStringResult(String stringResult) {
        this.stringResult = stringResult;
    }

    @Deprecated
    public boolean isValidSign() {
        return this.validSign;
    }

    @Deprecated
    public void setValidSign(boolean validSign) {
        this.validSign = validSign;
    }

    public boolean isSuccess() {
        return "SUCCESS".equalsIgnoreCase(this.state);
    }

    public <T> T unmarshal(Class<T> objectType) {
        if (objectType != null && StringUtils.isNotBlank(this.stringResult)) {
            return JacksonJsonMarshaller.unmarshal(this.stringResult, objectType);
        }
        return null;
    }

    public InputStream getFile() {
        return (InputStream)this.result;
    }

    public GZIPInputStream getGZIPInputStream() throws IOException {
        return new GZIPInputStream((InputStream)this.result);
    }

    public String toString() {
        String[] excludeFieldNames = new String[]{"headers,stringResult"};
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).setExcludeFieldNames(excludeFieldNames).toString();
    }
}

