/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope.rsa;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.BigFileCipherUtil;
import cfca.sadk.lib.crypto.jni.JNISymAlg;
import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.StreamUtil;
import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.StreamCipher;
import cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.sadk.org.bouncycastle.crypto.engines.RC4Engine;
import java.io.File;
import java.io.IOException;

public class RSAEncryptedInputStream
extends ASN1Primitive {
    private File f;
    private byte[] key;
    private Mechanism contentEncryptionAlg;
    private long totalLength;
    private boolean useJNIFlag = false;

    public RSAEncryptedInputStream() {
    }

    public static RSAEncryptedInputStream getInstance(Object obj) {
        if (obj != null && obj instanceof RSAEncryptedInputStream) {
            return (RSAEncryptedInputStream)obj;
        }
        return null;
    }

    public RSAEncryptedInputStream(boolean useJNIFlag, File f, byte[] key, Mechanism contentEncryptionAlg) throws PKIException {
        this.useJNIFlag = useJNIFlag;
        this.f = f;
        if (f.length() == 0L) {
            throw new PKIException("source file is empty!");
        }
        this.key = key;
        this.contentEncryptionAlg = contentEncryptionAlg;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isConstructed() {
        return false;
    }

    public int encodedLength() throws IOException {
        if (this.contentEncryptionAlg.getMechanismType().indexOf("DESede") != -1) {
            long srcLength = this.f.length();
            long padd = srcLength & 7L;
            this.totalLength = srcLength + 8L - padd;
        } else if (this.contentEncryptionAlg.getMechanismType().indexOf("RC4") != -1) {
            this.totalLength = this.f.length();
        } else {
            throw new IOException("can not support this algorithm:" + this.contentEncryptionAlg);
        }
        return 1 + StreamUtil.calculateBodyLength((int)this.totalLength) + (int)this.totalLength;
    }

    public void encode(ASN1OutputStream out) {
        try {
            out.write(4);
            out.writeLength((int)this.totalLength);
            this.cryptoUtil(this.key, this.contentEncryptionAlg, out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean asn1Equals(ASN1Primitive o) {
        return false;
    }

    private void cryptoUtil(byte[] key, Mechanism algName, ASN1OutputStream out) throws Exception {
        Object cipherEngine = null;
        String type = algName.getMechanismType();
        if (type.indexOf("DESede") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            if (this.useJNIFlag) {
                BigFileCipherUtil.bigFileEncrypt_JNI(JNISymAlg.NID_des_ede3_cbc, key, param.getIv(), this.f, out);
            } else {
                cipherEngine = new DESedeEngine();
                BigFileCipherUtil.bigFileBlockEncrypt(key, (BlockCipher)cipherEngine, param, this.f, out);
            }
        } else if (type.indexOf("DESede") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            if (this.useJNIFlag) {
                BigFileCipherUtil.bigFileEncrypt_JNI(JNISymAlg.NID_des_ede3_ecb, key, null, this.f, out);
            } else {
                cipherEngine = new DESedeEngine();
                BigFileCipherUtil.bigFileBlockEncrypt(key, (BlockCipher)cipherEngine, null, this.f, out);
            }
        } else if (type.indexOf("RC4") != -1) {
            if (this.useJNIFlag) {
                BigFileCipherUtil.bigFileEncrypt_JNI(JNISymAlg.NID_rc4, key, null, this.f, out);
            } else {
                cipherEngine = new RC4Engine();
                BigFileCipherUtil.bigFileRC4Encrypt(key, (StreamCipher)cipherEngine, this.f, out);
            }
        } else {
            throw new Exception("can not support this algorithm to encrypt:" + algName.getMechanismType());
        }
    }
}

