/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.encrypt;

import com.yeepay.g3.sdk.yop.utils.Exceptions;
import com.yeepay.shade.org.apache.commons.codec.DecoderException;
import com.yeepay.shade.org.apache.commons.codec.binary.Base64;
import com.yeepay.shade.org.apache.commons.codec.binary.Hex;
import com.yeepay.shade.org.apache.commons.codec.binary.StringUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringEscapeUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class Encodes {
    public static final String DEFAULT_URL_ENCODING = "UTF-8";
    private static final char[] BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final int[] DEFAULT_CONFOUNDER = new int[]{3, 6, 7, 4, 1, 8, 0, 9, 5, 2};

    public static String confuse(long num) {
        String tempStr = Long.toString(num);
        int numLength = tempStr.length();
        char[] input = tempStr.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numLength; ++i) {
            sb.append(DEFAULT_CONFOUNDER[Integer.parseInt(input[i] + "")]);
        }
        return sb.toString();
    }

    public static String encodeHex(byte[] input) {
        return Hex.encodeHexString(input);
    }

    public static byte[] decodeHex(String input) {
        try {
            return Hex.decodeHex(input.toCharArray());
        }
        catch (DecoderException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String encodeBase64(byte[] input) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(input));
    }

    public static String encodeUrlSafeBase64(byte[] input) {
        return Base64.encodeBase64URLSafeString(input);
    }

    public static byte[] decodeBase64(String input) {
        return Base64.decodeBase64(input);
    }

    public static String encodeBase62(byte[] input) {
        char[] chars = new char[input.length];
        for (int i = 0; i < input.length; ++i) {
            chars[i] = BASE62[(input[i] & 0xFF) % BASE62.length];
        }
        return new String(chars);
    }

    public static String escapeHtml(String html) {
        return StringEscapeUtils.escapeHtml4(html);
    }

    public static String unescapeHtml(String htmlEscaped) {
        return StringEscapeUtils.unescapeHtml4(htmlEscaped);
    }

    public static String escapeXml(String xml) {
        return StringEscapeUtils.escapeXml(xml);
    }

    public static String unescapeXml(String xmlEscaped) {
        return StringEscapeUtils.unescapeXml(xmlEscaped);
    }

    public static String urlEncode(String part) {
        try {
            return URLEncoder.encode(part, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String urlDecode(String part) {
        try {
            return URLDecoder.decode(part, DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.unchecked(e);
        }
    }
}

