/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils;

import com.yeepay.g3.sdk.yop.utils.RandomUtils;
import com.yeepay.shade.org.apache.commons.codec.binary.Base64;

public final class UUIDUtils {
    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static String randomV4UUID() {
        int i;
        byte[] randomBytes = new byte[16];
        RandomUtils.threadLocalRandom().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return UUIDUtils.digits(msb >> 32, 8) + UUIDUtils.digits(msb >> 16, 4) + UUIDUtils.digits(msb, 4) + UUIDUtils.digits(lsb >> 48, 4) + UUIDUtils.digits(lsb, 12);
    }

    public static String compressV4UUID() {
        int i;
        byte[] randomBytes = new byte[16];
        RandomUtils.threadLocalRandom().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        byte[] b = new byte[16];
        for (int i2 = 0; i2 < 8; ++i2) {
            b[i2] = (byte)(msb >>> 8 * (7 - i2) & 0xFFL);
            b[i2 + 8] = (byte)(lsb >>> 8 * (7 - i2) & 0xFFL);
        }
        return Base64.encodeBase64URLSafeString(b);
    }
}

