/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.x509.CRLDistPoint;
import cfca.sadk.org.bouncycastle.asn1.x509.DistributionPoint;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.x509.certificate.X509CRL;
import cfca.sadk.x509.certificate.X509CRLFile;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PublicKey;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public final class X509CertVerifier {
    private static Hashtable trustCerts = new Hashtable();

    public static void updateTrustCertsMap(String trustCerPath) throws PKIException {
        try {
            X509CertVerifier.updateTrustCertsMap(new X509Cert(trustCerPath));
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("CertVerifier update failure", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTrustCertsMap(X509Cert trustCert) throws PKIException {
        if (X509CertVerifier.isValid(trustCert)) {
            try {
                Hashtable hashtable = trustCerts;
                synchronized (hashtable) {
                    trustCerts.put(trustCert.getSubject(), trustCert.getPublicKey());
                    if (trustCert.getSubjectKeyIdentifier() != null) {
                        try {
                            String id = Hex.toHexString(trustCert.getSubjectKeyIdentifier().getKeyIdentifier());
                            trustCerts.put(id, trustCert.getPublicKey());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("CertVerifier update failure", e);
            }
        }
    }

    private static boolean isValid(X509Cert trustCert) {
        String signAlgorithmId = "1.2.156.10197.1.501";
        String keyTypeAlgorithmId = "1.2.840.113549.1.1.1";
        boolean isValid = false;
        if (trustCert != null) {
            isValid = "1.2.156.10197.1.501".equals(trustCert.getCertStructure().getSignatureAlgorithm().getAlgorithm().getId()) || "1.2.840.113549.1.1.1".equals(trustCert.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId());
        }
        return isValid;
    }

    public static void updateTrustCertsMap(X509Cert[] trustCerts) throws PKIException {
        if (trustCerts != null) {
            for (int i = 0; i < trustCerts.length; ++i) {
                X509CertVerifier.updateTrustCertsMap(trustCerts[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTrustCertsMap() {
        Hashtable hashtable = trustCerts;
        synchronized (hashtable) {
            trustCerts.clear();
        }
    }

    public static boolean validateCertSign(X509Cert cert) throws PKIException {
        if (cert == null) {
            throw new PKIException("null not allowed for parameter@cert");
        }
        PublicKey pubKey = null;
        if (cert.getAuthorityKeyIdentifier() != null) {
            try {
                String id = Hex.toHexString(cert.getAuthorityKeyIdentifier().getKeyIdentifier());
                pubKey = (PublicKey)trustCerts.get(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pubKey == null) {
            pubKey = (PublicKey)trustCerts.get(cert.getIssuer());
        }
        if (pubKey == null) {
            throw new PKIException("can not get the user issuer's cert");
        }
        return cert.verify(pubKey);
    }

    public static boolean verifyCertDate(X509Cert cert) {
        if (cert == null) {
            throw new SecurityException("null not allowed for parameter@cert");
        }
        Date current = new Date();
        boolean okay = true;
        if (current.before(cert.getNotBefore()) || current.after(cert.getNotAfter())) {
            okay = false;
        }
        return okay;
    }

    public static boolean verifyCertByCRLOutLine(X509Cert cert, String crlPath) throws PKIException {
        if (cert == null) {
            throw new PKIException("Required parameter cert");
        }
        X509CRLFile crlFile = new X509CRLFile(crlPath, false);
        boolean isValid = false;
        isValid = !crlFile.isRevoke(cert.getSerialNumber());
        return isValid;
    }

    public static String getCRLPointName(X509Cert cert) throws PKIException {
        CRLDistPoint crlDistExt = cert.getCRLDistributionPoints();
        if (crlDistExt == null || crlDistExt.getDistributionPoints() == null) {
            throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u9881\u53d1\u70b9\u4fe1\u606f");
        }
        int crlDistCount = crlDistExt.getDistributionPoints().length;
        String crl = null;
        for (int i = 0; i < crlDistCount; ++i) {
            DistributionPoint crlName = crlDistExt.getDistributionPoints()[i];
            String crlPointName = crlName.getDistributionPoint().toString();
            if (crlPointName.indexOf("ldap://") == -1) continue;
            crl = crlPointName;
        }
        if (crl == null) {
            throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u7684\u76ee\u5f55\u4fe1\u606f");
        }
        return crl;
    }

    public static boolean verifyCertByLDAP(X509Cert cert) throws PKIException {
        String crlPointName = X509CertVerifier.getCRLPointName(cert);
        if (crlPointName == null) {
            throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u9881\u53d1\u70b9\u4fe1\u606f");
        }
        int ldapIndex = crlPointName.indexOf("ldap://");
        crlPointName = crlPointName.substring(ldapIndex + 7, crlPointName.length());
        ldapIndex = crlPointName.indexOf(":");
        String ip = crlPointName.substring(0, ldapIndex);
        crlPointName = crlPointName.substring(ldapIndex + 1, crlPointName.length());
        ldapIndex = crlPointName.indexOf("/");
        String port = crlPointName.substring(0, ldapIndex);
        crlPointName = crlPointName.substring(ldapIndex + 1, crlPointName.length());
        ldapIndex = crlPointName.indexOf("?");
        String dn = crlPointName.substring(0, ldapIndex);
        String cn = crlPointName.substring(crlPointName.indexOf("=") + 1, crlPointName.indexOf(","));
        X509CRL x509Crl = null;
        try {
            x509Crl = X509CertVerifier.downloadCRL(ip, port, dn, cn);
        }
        catch (Exception ex) {
            throw new PKIException("850905", "\u4ece\u76ee\u5f55\u670d\u52a1\u5668\u4e0b\u8f7dCRL\u5931\u8d25", ex);
        }
        if (x509Crl != null) {
            return !x509Crl.isRevoke(cert.getSerialNumber());
        }
        throw new PKIException("850905", "\u4ece\u76ee\u5f55\u670d\u52a1\u5668\u4e0b\u8f7dCRL\u5931\u8d25");
    }

    private static X509CRL downloadCRL(String ip, String port, String dn, String cn) throws Exception {
        InitialDirContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + ip + ":" + port);
        env.put("java.naming.ldap.attributes.binary", "certificateRevocationList");
        ctx = new InitialDirContext(env);
        SearchControls tConstraints = new SearchControls();
        tConstraints.setSearchScope(2);
        NamingEnumeration<SearchResult> tResults = null;
        String filter = "(&(objectclass=cRLDistributionPoint)(cn=" + cn + "))";
        Object[] attrs = new String[]{"certificateRevocationList;binary"};
        X509CRL crl = null;
        try {
            tResults = ctx.search(dn, filter, attrs, tConstraints);
            if (tResults != null && tResults.hasMore()) {
                while (tResults.hasMore()) {
                    SearchResult tSearchRel = tResults.next();
                    Attributes allAttrs = tSearchRel.getAttributes();
                    Attribute attCRL = allAttrs.get("certificateRevocationList;binary");
                    byte[] bCRL = (byte[])attCRL.get(0);
                    crl = new X509CRL(bCRL);
                    bCRL = null;
                    attCRL = null;
                }
            }
            ctx.close();
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        return crl;
    }
}

