/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.http.HttpEntityEnclosingRequest;
import com.yeepay.shade.org.apache.http.HttpRequest;
import com.yeepay.shade.org.apache.http.NoHttpResponseException;
import com.yeepay.shade.org.apache.http.client.HttpRequestRetryHandler;
import com.yeepay.shade.org.apache.http.client.protocol.HttpClientContext;
import com.yeepay.shade.org.apache.http.conn.ConnectTimeoutException;
import com.yeepay.shade.org.apache.http.conn.ConnectionPoolTimeoutException;
import com.yeepay.shade.org.apache.http.protocol.HttpContext;
import com.yeepay.shade.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Set;
import javax.net.ssl.SSLException;

public class YopHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private final int retryCount;
    private final boolean requestSentRetryEnabled;
    private static final int SCALE_FACTOR = 300;
    private final Set<Class<? extends IOException>> nonRetriableClasses = Sets.newHashSet(InterruptedIOException.class, UnknownHostException.class, SocketException.class, ConnectException.class, SSLException.class);

    public YopHttpRequestRetryHandler() {
        this(3, false);
    }

    public YopHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        this.retryCount = retryCount;
        this.requestSentRetryEnabled = requestSentRetryEnabled;
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Args.notNull(exception, "Exception parameter");
        Args.notNull(context, "HTTP context");
        if (executionCount > this.retryCount) {
            return false;
        }
        if (this.nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (this.retryRequestWithSleep(exception, executionCount, context)) {
            try {
                Thread.sleep(this.getDelayBeforeNextRetryInMillis(executionCount));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    private long getDelayBeforeNextRetryInMillis(int retriesAttempted) {
        return (1 << retriesAttempted + 1) * 300;
    }

    private boolean retryRequestWithSleep(IOException exception, int executionCount, HttpContext context) {
        int statusCode;
        if (exception instanceof ConnectTimeoutException || exception instanceof NoHttpResponseException || exception instanceof UnknownHostException || exception instanceof ConnectionPoolTimeoutException) {
            return true;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        HttpRequest request = clientContext.getRequest();
        if (this.handleAsIdempotent(request)) {
            return true;
        }
        if (!clientContext.isRequestSent() || this.requestSentRetryEnabled) {
            return true;
        }
        int n = statusCode = null != clientContext.getResponse() ? clientContext.getResponse().getStatusLine().getStatusCode() : 0;
        return 502 == statusCode;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        return !(request instanceof HttpEntityEnclosingRequest);
    }
}

