/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client.router;

import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.router.GateWayRouter;
import com.yeepay.g3.sdk.yop.client.router.ServerRootSpace;
import com.yeepay.g3.sdk.yop.config.AppSdkConfig;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProviderRegistry;
import com.yeepay.g3.sdk.yop.config.enums.ModeEnum;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.shade.com.google.common.collect.Sets;
import com.yeepay.shade.org.apache.commons.collections4.MapUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;

public class SimpleGateWayRouter
implements GateWayRouter {
    private static final String SYSTEM_SDK_MODE_KEY = "yop.sdk.mode";
    private final ServerRootSpace space;
    private final Set<String> independentApiGroups;
    private final ModeEnum systemMode;

    public SimpleGateWayRouter(ServerRootSpace space) {
        this.space = space;
        this.independentApiGroups = Collections.unmodifiableSet(Sets.newHashSet("bank-encryption"));
        String systemModeConfig = System.getProperty(SYSTEM_SDK_MODE_KEY);
        this.systemMode = StringUtils.isEmpty(systemModeConfig) ? null : ModeEnum.valueOf(systemModeConfig);
    }

    @Override
    public String route(String apiUri, YopRequest request) {
        String serverRoot;
        if (this.isAppInSandbox(request.getAppSdkConfig().getAppKey())) {
            serverRoot = this.space.getSandboxServerRoot();
        } else {
            String apiGroup = this.extractApiGroupFromApiUri(apiUri);
            if (this.independentApiGroups.contains(apiGroup)) {
                URL independentServerRootURL;
                boolean isYosRequest = this.isYosRequest(apiUri, request);
                URL serverRootURL = isYosRequest ? this.space.getYosServerRootURL() : this.space.getServerRootURL();
                try {
                    independentServerRootURL = new URL(serverRootURL.getProtocol(), this.getIndependentApiGroupHost(apiGroup, serverRootURL.getHost(), isYosRequest), serverRootURL.getPort(), serverRootURL.getFile());
                }
                catch (MalformedURLException e) {
                    throw new YopClientException("route request failure");
                }
                serverRoot = independentServerRootURL.toString();
            } else {
                serverRoot = this.isYosRequest(apiUri, request) ? this.space.getYosServerRoot() : this.space.getServerRoot();
            }
        }
        return serverRoot;
    }

    private boolean isYosRequest(String apiUri, YopRequest request) {
        boolean isYosRequest = false;
        if (MapUtils.isNotEmpty(request.getMultipartFiles())) {
            isYosRequest = true;
            return isYosRequest;
        }
        if (StringUtils.startsWith(apiUri, "/yos")) {
            isYosRequest = true;
            return isYosRequest;
        }
        return isYosRequest;
    }

    private String extractApiGroupFromApiUri(String apiUri) {
        int startIndex = StringUtils.ordinalIndexOf(apiUri, "/", 3);
        if (startIndex < -1 || startIndex == apiUri.length() - 1) {
            throw new YopClientException("illegal apiUri:" + apiUri);
        }
        int endIndex = StringUtils.indexOf((CharSequence)apiUri, "/", startIndex + 1);
        if (endIndex < -1) {
            throw new YopClientException("illegal apiUri:" + apiUri);
        }
        return StringUtils.mid(apiUri, startIndex + 1, endIndex - startIndex - 1);
    }

    private boolean isAppInSandbox(String appKey) {
        if (this.systemMode == null) {
            AppSdkConfig appSdkConfig = AppSdkConfigProviderRegistry.getProvider().getConfig(appKey);
            if (appSdkConfig == null) {
                return false;
            }
            return appSdkConfig.getMode() == ModeEnum.sandbox;
        }
        return this.systemMode == ModeEnum.sandbox;
    }

    private String getIndependentApiGroupHost(String apiGroup, String originHost, boolean isYosRequest) {
        if (isYosRequest) {
            return originHost;
        }
        int index = StringUtils.indexOf((CharSequence)originHost, ".");
        return StringUtils.substring(originHost, 0, index) + "-" + apiGroup + StringUtils.substring(originHost, index);
    }
}

