/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.signers;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.math.ec.ECAlgorithms;
import com.timevale.tgtext.bouncycastle.math.ec.ECConstants;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNRSigner
implements DSA {
    private boolean forSigning;
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
                return;
            }
            this.random = new SecureRandom();
            this.key = (ECPrivateKeyParameters)param;
            return;
        }
        this.key = (ECPublicKeyParameters)param;
    }

    @Override
    public BigInteger[] generateSignature(byte[] digest) {
        ECKeyPairGenerator keyGen;
        AsymmetricCipherKeyPair tempPair;
        ECPublicKeyParameters V;
        BigInteger Vx;
        BigInteger r2;
        if (!this.forSigning) {
            throw new IllegalStateException("not initialised for signing");
        }
        BigInteger n2 = ((ECPrivateKeyParameters)this.key).getParameters().getN();
        int nBitLength = n2.bitLength();
        BigInteger e2 = new BigInteger(1, digest);
        int eBitLength = e2.bitLength();
        ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)this.key;
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        do {
            keyGen = new ECKeyPairGenerator();
            keyGen.init(new ECKeyGenerationParameters(privKey.getParameters(), this.random));
        } while ((r2 = (Vx = (V = (ECPublicKeyParameters)(tempPair = keyGen.generateKeyPair()).getPublic()).getQ().getX().toBigInteger()).add(e2).mod(n2)).equals(ECConstants.ZERO));
        BigInteger x2 = privKey.getD();
        BigInteger u2 = ((ECPrivateKeyParameters)tempPair.getPrivate()).getD();
        BigInteger s2 = u2.subtract(r2.multiply(x2)).mod(n2);
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger[] res = bigIntegerArray;
        bigIntegerArray[0] = r2;
        res[1] = s2;
        return res;
    }

    @Override
    public boolean verifySignature(byte[] digest, BigInteger r2, BigInteger s2) {
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying");
        }
        ECPublicKeyParameters pubKey = (ECPublicKeyParameters)this.key;
        BigInteger n2 = pubKey.getParameters().getN();
        int nBitLength = n2.bitLength();
        BigInteger e2 = new BigInteger(1, digest);
        int eBitLength = e2.bitLength();
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        if (r2.compareTo(ECConstants.ONE) < 0 || r2.compareTo(n2) >= 0) {
            return false;
        }
        if (s2.compareTo(ECConstants.ZERO) < 0 || s2.compareTo(n2) >= 0) {
            return false;
        }
        ECPoint G = pubKey.getParameters().getG();
        ECPoint W = pubKey.getQ();
        ECPoint P = ECAlgorithms.sumOfTwoMultiplies(G, s2, W, r2);
        BigInteger x2 = P.getX().toBigInteger();
        BigInteger t2 = r2.subtract(x2).mod(n2);
        return t2.equals(e2);
    }
}

