/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.dvcs;

import cfca.sadk.org.bouncycastle.asn1.ASN1Choice;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1TaggedObject;
import cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSCertInfo;
import cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSErrorNotice;
import java.io.IOException;

public class DVCSResponse
extends ASN1Object
implements ASN1Choice {
    private DVCSCertInfo dvCertInfo;
    private DVCSErrorNotice dvErrorNote;

    public DVCSResponse(DVCSCertInfo dvCertInfo) {
        this.dvCertInfo = dvCertInfo;
    }

    public DVCSResponse(DVCSErrorNotice dvErrorNote) {
        this.dvErrorNote = dvErrorNote;
    }

    public static DVCSResponse getInstance(Object obj) {
        if (obj == null || obj instanceof DVCSResponse) {
            return (DVCSResponse)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return DVCSResponse.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Sequence) {
            DVCSCertInfo dvCertInfo = DVCSCertInfo.getInstance(obj);
            return new DVCSResponse(dvCertInfo);
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject t = ASN1TaggedObject.getInstance(obj);
            DVCSErrorNotice dvErrorNote = DVCSErrorNotice.getInstance(t, false);
            return new DVCSResponse(dvErrorNote);
        }
        throw new IllegalArgumentException("Couldn't convert from object to DVCSResponse: " + obj.getClass().getName());
    }

    public static DVCSResponse getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DVCSResponse.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public DVCSCertInfo getCertInfo() {
        return this.dvCertInfo;
    }

    public DVCSErrorNotice getErrorNotice() {
        return this.dvErrorNote;
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.dvCertInfo != null) {
            return this.dvCertInfo.toASN1Primitive();
        }
        return new DERTaggedObject(0, this.dvErrorNote);
    }

    public String toString() {
        if (this.dvCertInfo != null) {
            return "DVCSResponse {\ndvCertInfo: " + this.dvCertInfo.toString() + "}\n";
        }
        if (this.dvErrorNote != null) {
            return "DVCSResponse {\ndvErrorNote: " + this.dvErrorNote.toString() + "}\n";
        }
        return "";
    }
}

