/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls;

import cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import cfca.sadk.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ServerName {
    protected short nameType;
    protected Object name;

    public ServerName(short nameType, Object name) {
        if (!ServerName.isCorrectType(nameType, name)) {
            throw new IllegalArgumentException("'name' is not an instance of the correct type");
        }
        this.nameType = nameType;
        this.name = name;
    }

    public short getNameType() {
        return this.nameType;
    }

    public Object getName() {
        return this.name;
    }

    public String getHostName() {
        if (!ServerName.isCorrectType((short)0, this.name)) {
            throw new IllegalStateException("'name' is not a HostName string");
        }
        return (String)this.name;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.nameType, output);
        switch (this.nameType) {
            case 0: {
                byte[] utf8Encoding = Strings.toUTF8ByteArray((String)this.name);
                if (utf8Encoding.length < 1) {
                    throw new TlsFatalAlert(80);
                }
                TlsUtils.writeOpaque16(utf8Encoding, output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static ServerName parse(InputStream input) throws IOException {
        String name;
        short name_type = TlsUtils.readUint8(input);
        switch (name_type) {
            case 0: {
                byte[] utf8Encoding = TlsUtils.readOpaque16(input);
                if (utf8Encoding.length < 1) {
                    throw new TlsFatalAlert(50);
                }
                name = Strings.fromUTF8ByteArray(utf8Encoding);
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new ServerName(name_type, name);
    }

    protected static boolean isCorrectType(short nameType, Object name) {
        switch (nameType) {
            case 0: {
                return name instanceof String;
            }
        }
        throw new IllegalArgumentException("'name' is an unsupported value");
    }
}

