/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.ec;

import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.ec.ECPair;
import cfca.sadk.org.bouncycastle.crypto.ec.ECPairTransform;
import cfca.sadk.org.bouncycastle.crypto.ec.ECUtil;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.sadk.org.bouncycastle.math.ec.ECMultiplier;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNewPublicKeyTransform
implements ECPairTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p = (ParametersWithRandom)param;
            if (!(p.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
            }
            this.key = (ECPublicKeyParameters)p.getParameters();
            this.random = p.getRandom();
        } else {
            if (!(param instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
            }
            this.key = (ECPublicKeyParameters)param;
            this.random = new SecureRandom();
        }
    }

    public ECPair transform(ECPair cipherText) {
        if (this.key == null) {
            throw new IllegalStateException("ECNewPublicKeyTransform not initialised");
        }
        ECDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        BigInteger k = ECUtil.generateK(n, this.random);
        ECPoint[] gamma_phi = new ECPoint[]{basePointMultiplier.multiply(ec.getG(), k), this.key.getQ().multiply(k).add(cipherText.getY())};
        ec.getCurve().normalizeAll(gamma_phi);
        return new ECPair(gamma_phi[0], gamma_phi[1]);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

