/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.spec;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.security.spec.KeySpec;

public class McEliecePrivateKeySpec
implements KeySpec {
    private String oid;
    private int n;
    private int k;
    private GF2mField field;
    private PolynomialGF2mSmallM goppaPoly;
    private GF2Matrix sInv;
    private Permutation p1;
    private Permutation p2;
    private GF2Matrix h;
    private PolynomialGF2mSmallM[] qInv;

    public McEliecePrivateKeySpec(String oid, int n2, int k2, GF2mField field, PolynomialGF2mSmallM goppaPoly, GF2Matrix sInv, Permutation p1, Permutation p2, GF2Matrix h2, PolynomialGF2mSmallM[] qInv) {
        this.oid = oid;
        this.k = k2;
        this.n = n2;
        this.field = field;
        this.goppaPoly = goppaPoly;
        this.sInv = sInv;
        this.p1 = p1;
        this.p2 = p2;
        this.h = h2;
        this.qInv = qInv;
    }

    public McEliecePrivateKeySpec(String oid, int n2, int k2, byte[] encField, byte[] encGoppaPoly, byte[] encSInv, byte[] encP1, byte[] encP2, byte[] encH, byte[][] encQInv) {
        this.oid = oid;
        this.n = n2;
        this.k = k2;
        this.field = new GF2mField(encField);
        this.goppaPoly = new PolynomialGF2mSmallM(this.field, encGoppaPoly);
        this.sInv = new GF2Matrix(encSInv);
        this.p1 = new Permutation(encP1);
        this.p2 = new Permutation(encP2);
        this.h = new GF2Matrix(encH);
        this.qInv = new PolynomialGF2mSmallM[encQInv.length];
        for (int i2 = 0; i2 < encQInv.length; ++i2) {
            this.qInv[i2] = new PolynomialGF2mSmallM(this.field, encQInv[i2]);
        }
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public GF2mField getField() {
        return this.field;
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.goppaPoly;
    }

    public GF2Matrix getSInv() {
        return this.sInv;
    }

    public Permutation getP1() {
        return this.p1;
    }

    public Permutation getP2() {
        return this.p2;
    }

    public GF2Matrix getH() {
        return this.h;
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.qInv;
    }

    public String getOIDString() {
        return this.oid;
    }
}

