/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.isismtt.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERPrintableString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.x500.DirectoryString;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.IssuerSerial;
import java.util.Enumeration;

public class ProcurationSyntax
extends ASN1Object {
    private String country;
    private DirectoryString typeOfSubstitution;
    private GeneralName thirdPerson;
    private IssuerSerial certRef;

    public static ProcurationSyntax getInstance(Object obj) {
        if (obj == null || obj instanceof ProcurationSyntax) {
            return (ProcurationSyntax)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ProcurationSyntax((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    private ProcurationSyntax(ASN1Sequence seq) {
        if (seq.size() <= 0 || seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration e2 = seq.getObjects();
        block5: while (e2.hasMoreElements()) {
            ASN1TaggedObject o2 = ASN1TaggedObject.getInstance(e2.nextElement());
            switch (o2.getTagNo()) {
                case 1: {
                    this.country = DERPrintableString.getInstance(o2, true).getString();
                    continue block5;
                }
                case 2: {
                    this.typeOfSubstitution = DirectoryString.getInstance(o2, true);
                    continue block5;
                }
                case 3: {
                    ASN1Primitive signingFor = o2.getObject();
                    if (signingFor instanceof ASN1TaggedObject) {
                        this.thirdPerson = GeneralName.getInstance(signingFor);
                        continue block5;
                    }
                    this.certRef = IssuerSerial.getInstance(signingFor);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Bad tag number: " + o2.getTagNo());
        }
    }

    public ProcurationSyntax(String country, DirectoryString typeOfSubstitution, IssuerSerial certRef) {
        this.country = country;
        this.typeOfSubstitution = typeOfSubstitution;
        this.thirdPerson = null;
        this.certRef = certRef;
    }

    public ProcurationSyntax(String country, DirectoryString typeOfSubstitution, GeneralName thirdPerson) {
        this.country = country;
        this.typeOfSubstitution = typeOfSubstitution;
        this.thirdPerson = thirdPerson;
        this.certRef = null;
    }

    public String getCountry() {
        return this.country;
    }

    public DirectoryString getTypeOfSubstitution() {
        return this.typeOfSubstitution;
    }

    public GeneralName getThirdPerson() {
        return this.thirdPerson;
    }

    public IssuerSerial getCertRef() {
        return this.certRef;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        if (this.country != null) {
            vec.add(new DERTaggedObject(true, 1, new DERPrintableString(this.country, true)));
        }
        if (this.typeOfSubstitution != null) {
            vec.add(new DERTaggedObject(true, 2, this.typeOfSubstitution));
        }
        if (this.thirdPerson != null) {
            vec.add(new DERTaggedObject(true, 3, this.thirdPerson));
        } else {
            vec.add(new DERTaggedObject(true, 3, this.certRef));
        }
        return new DERSequence(vec);
    }
}

