/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils;

import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Exceptions {
    public static RuntimeException unchecked(Throwable ex) {
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new RuntimeException(ex);
    }

    public static String getStackTraceAsString(Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        for (StackTraceElement e : ex.getStackTrace()) {
            String className = StringUtils.trim(e.getClassName());
            if (!StringUtils.startsWith(className, "at com.yeepay.g3") && StringUtils.startsWithAny(className, "at org.springframework.jdbc.support", "at org.springframework.transaction", "at org.springframework.aop", "at org.apache.ibatis", "at sun.reflect", "at com.ibm.db2", "at java.util.concurrent", "at com.sun.proxy")) continue;
            stringWriter.append(e.toString() + "\n");
        }
        return stringWriter.toString();
    }

    public static String getErrorMessageWithNestedException(Throwable ex) {
        String message = ex.getMessage();
        Throwable nestedException = ex.getCause();
        if (null != nestedException) {
            message = message + " nested exception is " + nestedException.getClass().getName() + ":" + nestedException.getMessage();
        }
        return message;
    }

    public static Throwable getRootCause(Throwable ex) {
        Throwable cause;
        while ((cause = ex.getCause()) != null) {
            ex = cause;
        }
        return ex;
    }

    public static boolean isCausedBy(Exception ex, Class<? extends Exception> ... causeExceptionClasses) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }
}

