/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.CompressedData;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSCompressedData;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessable;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedData;
import com.timevale.tgtext.bouncycastle.operator.OutputCompressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class CMSCompressedDataGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";

    public CMSCompressedData generate(CMSProcessable content, String compressionOID) throws CMSException {
        BEROctetString comOcts;
        AlgorithmIdentifier comAlgId;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DeflaterOutputStream zOut = new DeflaterOutputStream(bOut);
            content.write(zOut);
            zOut.close();
            comAlgId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(compressionOID));
            comOcts = new BEROctetString(bOut.toByteArray());
        }
        catch (IOException e2) {
            throw new CMSException("exception encoding data.", e2);
        }
        ContentInfo comContent = new ContentInfo(CMSObjectIdentifiers.data, comOcts);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.compressedData, new CompressedData(comAlgId, comContent));
        return new CMSCompressedData(contentInfo);
    }

    public CMSCompressedData generate(CMSTypedData content, OutputCompressor compressor) throws CMSException {
        BEROctetString comOcts;
        AlgorithmIdentifier comAlgId;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            OutputStream zOut = compressor.getOutputStream(bOut);
            content.write(zOut);
            zOut.close();
            comAlgId = compressor.getAlgorithmIdentifier();
            comOcts = new BEROctetString(bOut.toByteArray());
        }
        catch (IOException e2) {
            throw new CMSException("exception encoding data.", e2);
        }
        ContentInfo comContent = new ContentInfo(content.getContentType(), comOcts);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.compressedData, new CompressedData(comAlgId, comContent));
        return new CMSCompressedData(contentInfo);
    }
}

