/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.pqc.crypto.gmss.util;

import cfca.sadk.org.bouncycastle.crypto.Digest;

public class WinternitzOTSVerify {
    private Digest messDigestOTS;
    private int w;

    public WinternitzOTSVerify(Digest digest, int w) {
        this.w = w;
        this.messDigestOTS = digest;
    }

    public int getSignatureLength() {
        int mdsize = this.messDigestOTS.getDigestSize();
        int size = ((mdsize << 3) + (this.w - 1)) / this.w;
        int logs = this.getLog((size << this.w) + 1);
        return mdsize * (size += (logs + this.w - 1) / this.w);
    }

    public byte[] Verify(byte[] message, byte[] signature) {
        int d;
        int mdsize = this.messDigestOTS.getDigestSize();
        byte[] hash = new byte[mdsize];
        this.messDigestOTS.update(message, 0, message.length);
        hash = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(hash, 0);
        int size = ((mdsize << 3) + (this.w - 1)) / this.w;
        int logs = this.getLog((size << this.w) + 1);
        int keysize = size + (logs + this.w - 1) / this.w;
        int testKeySize = mdsize * keysize;
        if (testKeySize != signature.length) {
            return null;
        }
        byte[] testKey = new byte[testKeySize];
        int c = 0;
        int counter = 0;
        if (8 % this.w == 0) {
            int test;
            int i;
            d = 8 / this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            for (i = 0; i < hash.length; ++i) {
                for (int j = 0; j < d; ++j) {
                    c += test;
                    System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                    for (test = hash[i] & k; test < k; ++test) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                    }
                    System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                    hash[i] = (byte)(hash[i] >>> this.w);
                    ++counter;
                }
            }
            c = (size << this.w) - c;
            for (i = 0; i < logs; i += this.w) {
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test = c & k; test < k; ++test) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c >>>= this.w;
                ++counter;
            }
        } else if (this.w < 8) {
            int j;
            int test;
            long big8;
            int i;
            d = mdsize / this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            int ii = 0;
            for (i = 0; i < d; ++i) {
                int j2;
                big8 = 0L;
                for (j2 = 0; j2 < this.w; ++j2) {
                    big8 ^= (long)((hash[ii] & 0xFF) << (j2 << 3));
                    ++ii;
                }
                for (j2 = 0; j2 < 8; ++j2) {
                    c += test;
                    System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                    for (test = (int)(big8 & (long)k); test < k; ++test) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                    }
                    System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                    big8 >>>= this.w;
                    ++counter;
                }
            }
            d = mdsize % this.w;
            big8 = 0L;
            for (j = 0; j < d; ++j) {
                big8 ^= (long)((hash[ii] & 0xFF) << (j << 3));
                ++ii;
            }
            d <<= 3;
            for (j = 0; j < d; j += this.w) {
                c += test;
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test = (int)(big8 & (long)k); test < k; ++test) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                big8 >>>= this.w;
                ++counter;
            }
            c = (size << this.w) - c;
            for (i = 0; i < logs; i += this.w) {
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test = c & k; test < k; ++test) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c >>>= this.w;
                ++counter;
            }
        } else if (this.w < 57) {
            long test8;
            int j;
            int ii;
            long big8;
            int rest;
            int s;
            d = (mdsize << 3) - this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            int r = 0;
            while (r <= d) {
                s = r >>> 3;
                rest = r % 8;
                int f = (r += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                for (j = s; j < f; ++j) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c = (int)((long)c + test8);
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test8 = (big8 >>>= rest) & (long)k; test8 < (long)k; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                ++counter;
            }
            s = r >>> 3;
            if (s < mdsize) {
                rest = r % 8;
                big8 = 0L;
                ii = 0;
                for (j = s; j < mdsize; ++j) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c = (int)((long)c + test8);
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test8 = (big8 >>>= rest) & (long)k; test8 < (long)k; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                ++counter;
            }
            c = (size << this.w) - c;
            for (int i = 0; i < logs; i += this.w) {
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                for (test8 = (long)(c & k); test8 < (long)k; ++test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c >>>= this.w;
                ++counter;
            }
        }
        byte[] TKey = new byte[mdsize];
        this.messDigestOTS.update(testKey, 0, testKey.length);
        TKey = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(TKey, 0);
        return TKey;
    }

    public int getLog(int intValue) {
        int log = 1;
        int i = 2;
        while (i < intValue) {
            i <<= 1;
            ++log;
        }
        return log;
    }
}

