/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mMatrix
extends Matrix {
    protected GF2mField field;
    protected int[][] matrix;

    public GF2mMatrix(GF2mField field, byte[] enc) {
        int d2;
        this.field = field;
        int count = 1;
        for (d2 = 8; field.getDegree() > d2; d2 += 8) {
            ++count;
        }
        if (enc.length < 5) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numRows = (enc[3] & 0xFF) << 24 ^ (enc[2] & 0xFF) << 16 ^ (enc[1] & 0xFF) << 8 ^ enc[0] & 0xFF;
        int n2 = count * this.numRows;
        if (this.numRows <= 0 || (enc.length - 4) % n2 != 0) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numColumns = (enc.length - 4) / n2;
        this.matrix = new int[this.numRows][this.numColumns];
        count = 4;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.numColumns; ++j2) {
                for (int jj = 0; jj < d2; jj += 8) {
                    int[] nArray = this.matrix[i2];
                    int n3 = j2;
                    nArray[n3] = nArray[n3] ^ (enc[count++] & 0xFF) << jj;
                }
                if (this.field.isElementOfThisField(this.matrix[i2][j2])) continue;
                throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
            }
        }
    }

    public GF2mMatrix(GF2mMatrix other) {
        this.numRows = other.numRows;
        this.numColumns = other.numColumns;
        this.field = other.field;
        this.matrix = new int[this.numRows][];
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            this.matrix[i2] = IntUtils.clone(other.matrix[i2]);
        }
    }

    protected GF2mMatrix(GF2mField field, int[][] matrix) {
        this.field = field;
        this.matrix = matrix;
        this.numRows = matrix.length;
        this.numColumns = matrix[0].length;
    }

    @Override
    public byte[] getEncoded() {
        int d2;
        int count = 1;
        for (d2 = 8; this.field.getDegree() > d2; d2 += 8) {
            ++count;
        }
        byte[] byArray = new byte[this.numRows * this.numColumns * count + 4];
        byte[] bf2 = byArray;
        byArray[0] = (byte)this.numRows;
        bf2[1] = (byte)(this.numRows >>> 8);
        bf2[2] = (byte)(this.numRows >>> 16);
        bf2[3] = (byte)(this.numRows >>> 24);
        count = 4;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.numColumns; ++j2) {
                for (int jj = 0; jj < d2; jj += 8) {
                    bf2[count++] = (byte)(this.matrix[i2][j2] >>> jj);
                }
            }
        }
        return bf2;
    }

    @Override
    public boolean isZero() {
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.numColumns; ++j2) {
                if (this.matrix[i2][j2] == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Matrix computeInverse() {
        int i2;
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] tmpMatrix = new int[this.numRows][this.numRows];
        for (int i3 = this.numRows - 1; i3 >= 0; --i3) {
            tmpMatrix[i3] = IntUtils.clone(this.matrix[i3]);
        }
        int[][] invMatrix = new int[this.numRows][this.numRows];
        for (i2 = this.numRows - 1; i2 >= 0; --i2) {
            invMatrix[i2][i2] = 1;
        }
        for (i2 = 0; i2 < this.numRows; ++i2) {
            if (tmpMatrix[i2][i2] == 0) {
                boolean foundNonZero = false;
                for (int j2 = i2 + 1; j2 < this.numRows; ++j2) {
                    if (tmpMatrix[j2][i2] == 0) continue;
                    foundNonZero = true;
                    GF2mMatrix.swapColumns(tmpMatrix, i2, j2);
                    GF2mMatrix.swapColumns(invMatrix, i2, j2);
                    j2 = this.numRows;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            int coef = tmpMatrix[i2][i2];
            int invCoef = this.field.inverse(coef);
            this.multRowWithElementThis(tmpMatrix[i2], invCoef);
            this.multRowWithElementThis(invMatrix[i2], invCoef);
            for (int j3 = 0; j3 < this.numRows; ++j3) {
                if (j3 == i2 || (coef = tmpMatrix[j3][i2]) == 0) continue;
                int[] tmpRow = this.multRowWithElement(tmpMatrix[i2], coef);
                int[] tmpInvRow = this.multRowWithElement(invMatrix[i2], coef);
                this.addToRow(tmpRow, tmpMatrix[j3]);
                this.addToRow(tmpInvRow, invMatrix[j3]);
            }
        }
        return new GF2mMatrix(this.field, invMatrix);
    }

    private static void swapColumns(int[][] matrix, int first, int second) {
        int[] tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }

    private void multRowWithElementThis(int[] row, int element) {
        for (int i2 = row.length - 1; i2 >= 0; --i2) {
            row[i2] = this.field.mult(row[i2], element);
        }
    }

    private int[] multRowWithElement(int[] row, int element) {
        int[] result = new int[row.length];
        for (int i2 = row.length - 1; i2 >= 0; --i2) {
            result[i2] = this.field.mult(row[i2], element);
        }
        return result;
    }

    private void addToRow(int[] fromRow, int[] toRow) {
        for (int i2 = toRow.length - 1; i2 >= 0; --i2) {
            toRow[i2] = this.field.add(fromRow[i2], toRow[i2]);
        }
    }

    @Override
    public Matrix rightMultiply(Matrix a2) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Matrix rightMultiply(Permutation perm) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector leftMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector rightMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2mMatrix)) {
            return false;
        }
        GF2mMatrix otherMatrix = (GF2mMatrix)other;
        if (!this.field.equals(otherMatrix.field) || otherMatrix.numRows != this.numColumns || otherMatrix.numColumns != this.numColumns) {
            return false;
        }
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.numColumns; ++j2) {
                if (this.matrix[i2][j2] == otherMatrix.matrix[i2][j2]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = (this.field.hashCode() * 31 + this.numRows) * 31 + this.numColumns;
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.numColumns; ++j2) {
                hash = hash * 31 + this.matrix[i2][j2];
            }
        }
        return hash;
    }

    @Override
    public String toString() {
        String str = this.numRows + " x " + this.numColumns + " Matrix over " + this.field.toString() + ": \n";
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            for (int j2 = 0; j2 < this.numColumns; ++j2) {
                str = str + this.field.elementToStr(this.matrix[i2][j2]) + " : ";
            }
            str = str + "\n";
        }
        return str;
    }
}

