/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.symmetric;

import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.CipherKeyGenerator;
import cfca.sadk.org.bouncycastle.crypto.engines.SM4Engine;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.modes.CFBBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.modes.OFBBlockCipher;
import cfca.sadk.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class SM4 {
    static /* synthetic */ Class class$cfca$sadk$org$bouncycastle$jcajce$provider$symmetric$SM4;

    private SM4() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = (class$cfca$sadk$org$bouncycastle$jcajce$provider$symmetric$SM4 == null ? (class$cfca$sadk$org$bouncycastle$jcajce$provider$symmetric$SM4 = SM4.class$("cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.SM4")) : class$cfca$sadk$org$bouncycastle$jcajce$provider$symmetric$SM4).getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.SM4", PREFIX + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.SM4", PREFIX + "$AlgParamGen");
            provider.addAlgorithm("Cipher.SM4", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.SM4", PREFIX + "$KeyGen");
            provider.addAlgorithm("Cipher.PBEWithSM4-CBC", PREFIX + "$PBEWithSM4CBC");
            provider.addAlgorithm("Cipher.PBEWithSHA1AndSM4", PREFIX + "$PBEWithSHA1AndSM4");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "SM4 IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SM4 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("SM4", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class PBEWithSHA1AndSM4
    extends PBESecretKeyFactory {
        public PBEWithSHA1AndSM4() {
            super("PBEWithSHA1AndSM4", null, true, 2, 1, 128, 128);
        }
    }

    public static class PBEWithSM4CBC
    extends BaseBlockCipher {
        public PBEWithSM4CBC() {
            super(new CBCBlockCipher(new SM4Engine()));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(128);
        }

        public KeyGen(int keySize) {
            super("SM4", 128, new CipherKeyGenerator());
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new SM4Engine(), 128)), 128);
        }
    }

    public static class CFB
    extends BaseBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new SM4Engine(), 128)), 128);
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SM4Engine()), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new SM4Engine();
                }
            });
        }
    }
}

