/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.crypto.ec.CustomNamedCurves;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import java.util.List;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        X9ECParameters ecP = CustomNamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = CustomNamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (ecP == null && (ecP = cfca.sadk.org.bouncycastle.asn1.x9.ECNamedCurveTable.getByName(name)) == null) {
                try {
                    ecP = cfca.sadk.org.bouncycastle.asn1.x9.ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(name));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static List getNames() {
        return cfca.sadk.org.bouncycastle.asn1.x9.ECNamedCurveTable.getNameList();
    }
}

