/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.JcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.openssl.PEMException;
import com.timevale.tgtext.bouncycastle.openssl.PEMKeyPair;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class JcaPEMKeyConverter {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcaPEMKeyConverter setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaPEMKeyConverter setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public KeyPair getKeyPair(PEMKeyPair keyPair) throws PEMException {
        try {
            String algorithm = keyPair.getPrivateKeyInfo().getPrivateKeyAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(algorithm)) {
                algorithm = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(algorithm);
            return new KeyPair(keyFactory.generatePublic(new X509EncodedKeySpec(keyPair.getPublicKeyInfo().getEncoded())), keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyPair.getPrivateKeyInfo().getEncoded())));
        }
        catch (Exception e2) {
            throw new PEMException("unable to convert key pair: " + e2.getMessage(), e2);
        }
    }

    public PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws PEMException {
        try {
            String algorithm = publicKeyInfo.getAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(algorithm)) {
                algorithm = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(algorithm);
            return keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyInfo.getEncoded()));
        }
        catch (Exception e2) {
            throw new PEMException("unable to convert key pair: " + e2.getMessage(), e2);
        }
    }

    public PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws PEMException {
        try {
            String algorithm = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(algorithm)) {
                algorithm = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(algorithm);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
        }
        catch (Exception e2) {
            throw new PEMException("unable to convert key pair: " + e2.getMessage(), e2);
        }
    }
}

