/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.pkcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.BERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DLSequence;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.ContentInfo;

public class AuthenticatedSafe
extends ASN1Object {
    private ContentInfo[] info;
    private boolean isBer = true;

    private AuthenticatedSafe(ASN1Sequence seq) {
        this.info = new ContentInfo[seq.size()];
        for (int i2 = 0; i2 != this.info.length; ++i2) {
            this.info[i2] = ContentInfo.getInstance(seq.getObjectAt(i2));
        }
        this.isBer = seq instanceof BERSequence;
    }

    public static AuthenticatedSafe getInstance(Object o2) {
        if (o2 instanceof AuthenticatedSafe) {
            return (AuthenticatedSafe)o2;
        }
        if (o2 != null) {
            return new AuthenticatedSafe(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public AuthenticatedSafe(ContentInfo[] info) {
        this.info = info;
    }

    public ContentInfo[] getContentInfo() {
        return this.info;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.info.length; ++i2) {
            v2.add(this.info[i2]);
        }
        if (this.isBer) {
            return new BERSequence(v2);
        }
        return new DLSequence(v2);
    }
}

