/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.core.notify;

import com.huifu.adapay.core.AdapayCore;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.exception.FailureCode;
import com.huifu.adapay.core.model.Token;
import com.huifu.adapay.core.notify.INotifyCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttCallbackEvent
implements MqttCallbackExtended {
    private String apiKey;
    private String privateKey;
    public static String defaultDeviceID = "adapay_001";
    private static final String MQTT_INSTANCE_ID_PROD = "post-cn-0pp18zowf0m";
    private static final String MQTT_END_POINT_PROD = "tcp://post-cn-0pp18zowf0m.mqtt.aliyuncs.com:1883";
    private static final String MQTT_ACCESS_KEY_PROD = "LTAIOP5RkeiuXieW";
    private static final String MQTT_CLIENT_ID_PREFIX_PROD = "GID_CRHS_ASYN@@@";
    private static final String MQTT_TOPIC_PREFIX_PROD = "topic_crhs_sender/";
    private static final int QOS_LEVEL = 1;
    private int errorCnt = 0;
    private static final ThreadPoolExecutor MQTT_ASYNC_THREAD_POOL = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 2, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(500), new SimpleThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    private MqttClient mqttClient;
    private INotifyCallback asyCallback;

    private static String getMqttClientId(String apiKey) {
        String deviceId = DigestUtils.md5Hex((String)(apiKey + defaultDeviceID));
        String clientId = MQTT_CLIENT_ID_PREFIX_PROD + deviceId;
        System.out.println("apiKey:" + apiKey + " \u5bf9\u5e94\u7684 MQTT clientId:" + clientId);
        return clientId;
    }

    private static String getMqttTopic(String apiKey) {
        String topic = MQTT_TOPIC_PREFIX_PROD + apiKey;
        return topic;
    }

    public static void startMqtt(String apikey, String privatekey, INotifyCallback asyCallback, String deviceID) throws Exception {
        MqttCallbackEvent event = new MqttCallbackEvent(apikey, privatekey, asyCallback);
        if (null != deviceID && !deviceID.isEmpty()) {
            defaultDeviceID = deviceID;
        }
        event.startNotifyListener();
    }

    private MqttCallbackEvent(String apikey, String privatekey, INotifyCallback asyCallback) {
        this.apiKey = apikey;
        this.privateKey = privatekey;
        this.asyCallback = asyCallback;
    }

    public static String getMqttToken(String privateKey, String apiKey) throws Exception {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>(1);
        tokenParams.put("expire_time", 604800);
        String token = (String)Token.apply(tokenParams, privateKey, apiKey).get("token");
        if (null == token) {
            throw new BaseAdaPayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "token\u83b7\u53d6\u5931\u8d25\uff0c\u5e38\u89c1\u4e3a\u5546\u6237\u79d8\u94a5\u914d\u7f6e\u9519\u8bef");
        }
        return token;
    }

    private void startNotifyListener() throws Exception {
        String token = MqttCallbackEvent.getMqttToken(this.privateKey, this.apiKey);
        HashMap<String, String> tokenData = new HashMap<String, String>(1);
        tokenData.put("R", token);
        MqttConnectOptions mqttConnectOptions = this.ConnectionOptionWrapper(tokenData);
        MemoryPersistence memoryPersistence = new MemoryPersistence();
        this.mqttClient = new MqttClient(MQTT_END_POINT_PROD, MqttCallbackEvent.getMqttClientId(this.apiKey), (MqttClientPersistence)memoryPersistence);
        this.mqttClient.setCallback((MqttCallback)this);
        this.mqttClient.setTimeToWait(5000L);
        this.mqttClient.connect(mqttConnectOptions);
        if (AdapayCore.debug) {
            System.out.println("MQTT Token|" + token + "| + topic = " + MqttCallbackEvent.getMqttTopic(this.apiKey));
        }
    }

    private MqttConnectOptions ConnectionOptionWrapper(Map<String, String> inputTokenData) {
        ConcurrentHashMap<String, String> tokenData = new ConcurrentHashMap<String, String>(1);
        if (inputTokenData != null) {
            tokenData.putAll(inputTokenData);
        }
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setUserName("Token|LTAIOP5RkeiuXieW|post-cn-0pp18zowf0m");
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : tokenData.entrySet()) {
            builder.append((String)entry.getKey()).append("|").append((String)entry.getValue()).append("|");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        mqttConnectOptions.setPassword(builder.toString().toCharArray());
        mqttConnectOptions.setCleanSession(false);
        mqttConnectOptions.setKeepAliveInterval(90);
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setMqttVersion(4);
        mqttConnectOptions.setConnectionTimeout(5000);
        return mqttConnectOptions;
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        if (AdapayCore.debug) {
            System.out.println("connect success, reconnect=" + reconnect + ", serverURI=" + serverURI);
        }
        MQTT_ASYNC_THREAD_POOL.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] topicFilter = new String[]{MqttCallbackEvent.getMqttTopic(MqttCallbackEvent.this.apiKey)};
                    int[] qos = new int[]{1};
                    MqttCallbackEvent.this.mqttClient.subscribe(topicFilter, qos);
                    MqttCallbackEvent.this.asyCallback.connectSuccess();
                }
                catch (MqttException e) {
                    System.err.println("MQTT\u8ba2\u9605\u51fa\u73b0\u95ee\u9898\uff0c\u8be6\u89c1\u65e5\u5fd7");
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.errorCnt = 0;
    }

    public void connectionLost(Throwable throwable) {
        try {
            this.asyCallback.connectionLost();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void messageArrived(String topicName, final MqttMessage messageBody) throws Exception {
        MQTT_ASYNC_THREAD_POOL.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String message = new String(messageBody.getPayload());
                    System.out.println("MQTT received message :" + message);
                    MqttCallbackEvent.this.asyCallback.messageArrived(message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        if (AdapayCore.debug) {
            System.out.println("delivery complete");
        }
    }

    private static class SimpleThreadFactory
    implements ThreadFactory {
        private SimpleThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AdaPay-Callback-Listener");
        }
    }
}

