/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.BEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.SignedData;
import cfca.sadk.org.bouncycastle.asn1.cms.SignerInfo;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSProcessable;
import cfca.sadk.org.bouncycastle.cms.CMSProcessableByteArray;
import cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import cfca.sadk.org.bouncycastle.cms.CMSSignedGenerator;
import cfca.sadk.org.bouncycastle.cms.CMSSignedHelper;
import cfca.sadk.org.bouncycastle.cms.CMSTypedData;
import cfca.sadk.org.bouncycastle.cms.CMSUtils;
import cfca.sadk.org.bouncycastle.cms.SignerInfoGenerator;
import cfca.sadk.org.bouncycastle.cms.SignerInformation;
import cfca.sadk.org.bouncycastle.cms.SignerInformationStore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        Iterator it = this._signers.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            signerInfos.add(signer.toASN1Structure());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        BEROctetString octs = null;
        if (content.getContent() != null) {
            ByteArrayOutputStream bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, bOut);
            cOut = CMSUtils.getSafeOutputStream(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), e);
            }
            if (encapsulate) {
                octs = new BEROctetString(bOut.toByteArray());
            }
        }
        Iterator it2 = this.signerGens.iterator();
        while (it2.hasNext()) {
            SignerInfoGenerator sGen = (SignerInfoGenerator)it2.next();
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add(inf.getDigestAlgorithm());
            signerInfos.add(inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, sd);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws CMSException {
        return this.generate(new CMSProcessableByteArray(null, signer.getSignature()), false).getSignerInfos();
    }
}

