/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.encrypt;

import java.util.HashMap;
import java.util.Map;

public enum DigestAlgEnum {
    SHA256("SHA256", "sha-256\u6458\u8981"),
    SHA512("SHA512", "sha-512\u6458\u8981");

    private static final Map<String, DigestAlgEnum> VALUE_MAP;
    private String value;
    private String displayName;

    private DigestAlgEnum(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public static DigestAlgEnum parse(String value) {
        return VALUE_MAP.get(value);
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Map<String, DigestAlgEnum> getValueMap() {
        return VALUE_MAP;
    }

    static {
        VALUE_MAP = new HashMap<String, DigestAlgEnum>();
        for (DigestAlgEnum item : DigestAlgEnum.values()) {
            VALUE_MAP.put(item.value, item);
        }
    }
}

