/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERGeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERUTCTime;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.Time;
import java.util.Enumeration;

public class TBSCertList
extends ASN1Object {
    ASN1Integer version;
    AlgorithmIdentifier signature;
    X500Name issuer;
    Time thisUpdate;
    Time nextUpdate;
    ASN1Sequence revokedCertificates;
    Extensions crlExtensions;

    public static TBSCertList getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSCertList.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSCertList getInstance(Object obj) {
        if (obj instanceof TBSCertList) {
            return (TBSCertList)obj;
        }
        if (obj != null) {
            return new TBSCertList(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public TBSCertList(ASN1Sequence seq) {
        if (seq.size() < 3 || seq.size() > 7) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int seqPos = 0;
        this.version = seq.getObjectAt(0) instanceof ASN1Integer ? ASN1Integer.getInstance(seq.getObjectAt(0)) : null;
        int n2 = ++seqPos;
        this.signature = AlgorithmIdentifier.getInstance(seq.getObjectAt(n2));
        int n3 = ++seqPos;
        this.issuer = X500Name.getInstance(seq.getObjectAt(n3));
        int n4 = ++seqPos;
        this.thisUpdate = Time.getInstance(seq.getObjectAt(n4));
        if (++seqPos < seq.size() && (seq.getObjectAt(seqPos) instanceof DERUTCTime || seq.getObjectAt(seqPos) instanceof DERGeneralizedTime || seq.getObjectAt(seqPos) instanceof Time)) {
            this.nextUpdate = Time.getInstance(seq.getObjectAt(seqPos++));
        }
        if (seqPos < seq.size() && !(seq.getObjectAt(seqPos) instanceof DERTaggedObject)) {
            this.revokedCertificates = ASN1Sequence.getInstance(seq.getObjectAt(seqPos++));
        }
        if (seqPos < seq.size() && seq.getObjectAt(seqPos) instanceof DERTaggedObject) {
            this.crlExtensions = Extensions.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(seqPos), true));
        }
    }

    public int getVersionNumber() {
        if (this.version == null) {
            return 1;
        }
        return this.version.getValue().intValue() + 1;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Time getThisUpdate() {
        return this.thisUpdate;
    }

    public Time getNextUpdate() {
        return this.nextUpdate;
    }

    public CRLEntry[] getRevokedCertificates() {
        if (this.revokedCertificates == null) {
            return new CRLEntry[0];
        }
        CRLEntry[] entries = new CRLEntry[this.revokedCertificates.size()];
        for (int i2 = 0; i2 < entries.length; ++i2) {
            entries[i2] = CRLEntry.getInstance(this.revokedCertificates.getObjectAt(i2));
        }
        return entries;
    }

    public Enumeration getRevokedCertificateEnumeration() {
        if (this.revokedCertificates == null) {
            return new a();
        }
        return new b(this.revokedCertificates.getObjects());
    }

    public Extensions getExtensions() {
        return this.crlExtensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.version != null) {
            v2.add(this.version);
        }
        v2.add(this.signature);
        v2.add(this.issuer);
        v2.add(this.thisUpdate);
        if (this.nextUpdate != null) {
            v2.add(this.nextUpdate);
        }
        if (this.revokedCertificates != null) {
            v2.add(this.revokedCertificates);
        }
        if (this.crlExtensions != null) {
            v2.add(new DERTaggedObject(0, this.crlExtensions));
        }
        return new DERSequence(v2);
    }

    private class a
    implements Enumeration {
        private a() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }

    private class b
    implements Enumeration {
        private final Enumeration b;

        b(Enumeration en2) {
            this.b = en2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.b.hasMoreElements();
        }

        public Object nextElement() {
            return CRLEntry.getInstance(this.b.nextElement());
        }
    }

    public static class CRLEntry
    extends ASN1Object {
        ASN1Sequence seq;
        Extensions crlEntryExtensions;

        private CRLEntry(ASN1Sequence seq) {
            if (seq.size() < 2 || seq.size() > 3) {
                throw new IllegalArgumentException("Bad sequence size: " + seq.size());
            }
            this.seq = seq;
        }

        public static CRLEntry getInstance(Object o2) {
            if (o2 instanceof CRLEntry) {
                return (CRLEntry)o2;
            }
            if (o2 != null) {
                return new CRLEntry(ASN1Sequence.getInstance(o2));
            }
            return null;
        }

        public ASN1Integer getUserCertificate() {
            return ASN1Integer.getInstance(this.seq.getObjectAt(0));
        }

        public Time getRevocationDate() {
            return Time.getInstance(this.seq.getObjectAt(1));
        }

        public Extensions getExtensions() {
            if (this.crlEntryExtensions == null && this.seq.size() == 3) {
                this.crlEntryExtensions = Extensions.getInstance(this.seq.getObjectAt(2));
            }
            return this.crlEntryExtensions;
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            return this.seq;
        }

        public boolean hasExtensions() {
            return this.seq.size() == 3;
        }
    }
}

