/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.entity.asn1;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;

public class SM2Entity
extends PKCS12_SM2 {
    public SM2Entity() {
    }

    public SM2Entity(String pfxFilePath, String pfxFilePassword) throws DataLengthException, IllegalStateException, InvalidCipherTextException, PKIException, IOException {
        this.load(pfxFilePath, pfxFilePassword);
    }

    public SM2Entity(InputStream pfxInputStream, String pfxFilePassword) throws DataLengthException, IllegalStateException, InvalidCipherTextException, PKIException, IOException {
        this.load(pfxInputStream, pfxFilePassword);
    }

    public SM2Entity(byte[] pfxByteData, String pfxFilePassword) throws DataLengthException, IllegalStateException, InvalidCipherTextException, PKIException, IOException {
        this.load(pfxByteData, pfxFilePassword);
    }

    public void load(String pfxFilePath, String pfxFilePassword) throws DataLengthException, IllegalStateException, InvalidCipherTextException, PKIException, IOException {
        FileInputStream is = new FileInputStream(pfxFilePath);
        this.load(is, pfxFilePassword);
    }

    public void load(InputStream pfxInputStream, String pfxFilePassword) throws DataLengthException, IllegalStateException, InvalidCipherTextException, PKIException, IOException {
        byte[] pfxByteData = new byte[pfxInputStream.available()];
        pfxInputStream.read(pfxByteData);
        pfxInputStream.close();
        this.load(pfxByteData, pfxFilePassword);
    }

    public void load(byte[] pfxByteData, String pfxFilePassword) throws DataLengthException, IllegalStateException, InvalidCipherTextException, PKIException, IOException {
        super.load(pfxByteData);
        super.decrypt(pfxFilePassword);
    }

    public X509Cert[] getCerts() throws PKIException {
        return super.getPublicCert();
    }

    public PrivateKey getPrivateKey() throws PKIException {
        return super.getPrivateKey();
    }
}

